// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The collection of settings used by an AutoML job V2 for the text generation problem type.
 *
 * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in regions supported by Canvas. Refer to the documentation of Canvas for the [full list of its supported Regions](https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html).
 */
public class TextGenerationJobConfig private constructor(builder: Builder) {
    /**
     * The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language models. For information on the list of supported models, see [Text generation models supporting fine-tuning in Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-models.html#autopilot-llms-finetuning-supported-llms). If no `BaseModelName` is provided, the default model used is **Falcon7BInstruct**.
     */
    public val baseModelName: kotlin.String? = builder.baseModelName
    /**
     * How long a fine-tuning job is allowed to run. For `TextGenerationJobConfig` problem types, the `MaxRuntimePerTrainingJobInSeconds` attribute of `AutoMLJobCompletionCriteria` defaults to 72h (259200s).
     */
    public val completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = builder.completionCriteria
    /**
     * The hyperparameters used to configure and optimize the learning process of the base model. You can set any combination of the following hyperparameters for all base models. For more information on each supported hyperparameter, see [Optimize the learning process of your text generation models with hyperparameters](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-set-hyperparameters.html).
     * + `"epochCount"`: The number of times the model goes through the entire training dataset. Its value should be a string containing an integer value within the range of "1" to "10".
     * + `"batchSize"`: The number of data samples used in each iteration of training. Its value should be a string containing an integer value within the range of "1" to "64".
     * + `"learningRate"`: The step size at which a model's parameters are updated during training. Its value should be a string containing a floating-point value within the range of "0" to "1".
     * + `"learningRateWarmupSteps"`: The number of training steps during which the learning rate gradually increases before reaching its target or maximum value. Its value should be a string containing an integer value within the range of "0" to "250".
     *
     * Here is an example where all four hyperparameters are configured.
     *
     * `{ "epochCount":"5", "learningRate":"0.5", "batchSize": "32", "learningRateWarmupSteps": "10" }`
     */
    public val textGenerationHyperParameters: Map<String, String>? = builder.textGenerationHyperParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TextGenerationJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TextGenerationJobConfig(")
        append("baseModelName=$baseModelName,")
        append("completionCriteria=$completionCriteria,")
        append("textGenerationHyperParameters=$textGenerationHyperParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelName?.hashCode() ?: 0
        result = 31 * result + (completionCriteria?.hashCode() ?: 0)
        result = 31 * result + (textGenerationHyperParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TextGenerationJobConfig

        if (baseModelName != other.baseModelName) return false
        if (completionCriteria != other.completionCriteria) return false
        if (textGenerationHyperParameters != other.textGenerationHyperParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TextGenerationJobConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language models. For information on the list of supported models, see [Text generation models supporting fine-tuning in Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-models.html#autopilot-llms-finetuning-supported-llms). If no `BaseModelName` is provided, the default model used is **Falcon7BInstruct**.
         */
        public var baseModelName: kotlin.String? = null
        /**
         * How long a fine-tuning job is allowed to run. For `TextGenerationJobConfig` problem types, the `MaxRuntimePerTrainingJobInSeconds` attribute of `AutoMLJobCompletionCriteria` defaults to 72h (259200s).
         */
        public var completionCriteria: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria? = null
        /**
         * The hyperparameters used to configure and optimize the learning process of the base model. You can set any combination of the following hyperparameters for all base models. For more information on each supported hyperparameter, see [Optimize the learning process of your text generation models with hyperparameters](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-set-hyperparameters.html).
         * + `"epochCount"`: The number of times the model goes through the entire training dataset. Its value should be a string containing an integer value within the range of "1" to "10".
         * + `"batchSize"`: The number of data samples used in each iteration of training. Its value should be a string containing an integer value within the range of "1" to "64".
         * + `"learningRate"`: The step size at which a model's parameters are updated during training. Its value should be a string containing a floating-point value within the range of "0" to "1".
         * + `"learningRateWarmupSteps"`: The number of training steps during which the learning rate gradually increases before reaching its target or maximum value. Its value should be a string containing an integer value within the range of "0" to "250".
         *
         * Here is an example where all four hyperparameters are configured.
         *
         * `{ "epochCount":"5", "learningRate":"0.5", "batchSize": "32", "learningRateWarmupSteps": "10" }`
         */
        public var textGenerationHyperParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TextGenerationJobConfig) : this() {
            this.baseModelName = x.baseModelName
            this.completionCriteria = x.completionCriteria
            this.textGenerationHyperParameters = x.textGenerationHyperParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TextGenerationJobConfig = TextGenerationJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria] inside the given [block]
         */
        public fun completionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.completionCriteria = aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
