// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class RenderUiTemplateRequest private constructor(builder: Builder) {
    /**
     * The `HumanTaskUiArn` of the worker UI that you want to render. Do not provide a `HumanTaskUiArn` if you use the `UiTemplate` parameter.
     *
     * See a list of available Human Ui Amazon Resource Names (ARNs) in [UiConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UiConfig.html).
     */
    public val humanTaskUiArn: kotlin.String? = builder.humanTaskUiArn
    /**
     * The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A `RenderableTask` object containing a representative task to render.
     */
    public val task: aws.sdk.kotlin.services.sagemaker.model.RenderableTask? = builder.task
    /**
     * A `Template` object containing the worker UI template to render.
     */
    public val uiTemplate: aws.sdk.kotlin.services.sagemaker.model.UiTemplate? = builder.uiTemplate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RenderUiTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenderUiTemplateRequest(")
        append("humanTaskUiArn=$humanTaskUiArn,")
        append("roleArn=$roleArn,")
        append("task=$task,")
        append("uiTemplate=$uiTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = humanTaskUiArn?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (uiTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenderUiTemplateRequest

        if (humanTaskUiArn != other.humanTaskUiArn) return false
        if (roleArn != other.roleArn) return false
        if (task != other.task) return false
        if (uiTemplate != other.uiTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RenderUiTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `HumanTaskUiArn` of the worker UI that you want to render. Do not provide a `HumanTaskUiArn` if you use the `UiTemplate` parameter.
         *
         * See a list of available Human Ui Amazon Resource Names (ARNs) in [UiConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UiConfig.html).
         */
        public var humanTaskUiArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A `RenderableTask` object containing a representative task to render.
         */
        public var task: aws.sdk.kotlin.services.sagemaker.model.RenderableTask? = null
        /**
         * A `Template` object containing the worker UI template to render.
         */
        public var uiTemplate: aws.sdk.kotlin.services.sagemaker.model.UiTemplate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RenderUiTemplateRequest) : this() {
            this.humanTaskUiArn = x.humanTaskUiArn
            this.roleArn = x.roleArn
            this.task = x.task
            this.uiTemplate = x.uiTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RenderUiTemplateRequest = RenderUiTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RenderableTask] inside the given [block]
         */
        public fun task(block: aws.sdk.kotlin.services.sagemaker.model.RenderableTask.Builder.() -> kotlin.Unit) {
            this.task = aws.sdk.kotlin.services.sagemaker.model.RenderableTask.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UiTemplate] inside the given [block]
         */
        public fun uiTemplate(block: aws.sdk.kotlin.services.sagemaker.model.UiTemplate.Builder.() -> kotlin.Unit) {
            this.uiTemplate = aws.sdk.kotlin.services.sagemaker.model.UiTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
