// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of a project as returned by the Search API.
 */
public class Project private constructor(builder: Builder) {
    /**
     * Who created the project.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * A timestamp specifying when the project was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * A timestamp container for when the project was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the project.
     */
    public val projectArn: kotlin.String? = builder.projectArn
    /**
     * The description of the project.
     */
    public val projectDescription: kotlin.String? = builder.projectDescription
    /**
     * The ID of the project.
     */
    public val projectId: kotlin.String? = builder.projectId
    /**
     * The name of the project.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * The status of the project.
     */
    public val projectStatus: aws.sdk.kotlin.services.sagemaker.model.ProjectStatus? = builder.projectStatus
    /**
     * Details of a provisioned service catalog product. For information about service catalog, see [What is Amazon Web Services Service Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
     */
    public val serviceCatalogProvisionedProductDetails: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails? = builder.serviceCatalogProvisionedProductDetails
    /**
     * Details that you specify to provision a service catalog product. For information about service catalog, see [What is Amazon Web Services Service Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
     */
    public val serviceCatalogProvisioningDetails: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails? = builder.serviceCatalogProvisioningDetails
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Project = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Project(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("projectArn=$projectArn,")
        append("projectDescription=$projectDescription,")
        append("projectId=$projectId,")
        append("projectName=$projectName,")
        append("projectStatus=$projectStatus,")
        append("serviceCatalogProvisionedProductDetails=$serviceCatalogProvisionedProductDetails,")
        append("serviceCatalogProvisioningDetails=$serviceCatalogProvisioningDetails,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        result = 31 * result + (projectDescription?.hashCode() ?: 0)
        result = 31 * result + (projectId?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (projectStatus?.hashCode() ?: 0)
        result = 31 * result + (serviceCatalogProvisionedProductDetails?.hashCode() ?: 0)
        result = 31 * result + (serviceCatalogProvisioningDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Project

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (projectArn != other.projectArn) return false
        if (projectDescription != other.projectDescription) return false
        if (projectId != other.projectId) return false
        if (projectName != other.projectName) return false
        if (projectStatus != other.projectStatus) return false
        if (serviceCatalogProvisionedProductDetails != other.serviceCatalogProvisionedProductDetails) return false
        if (serviceCatalogProvisioningDetails != other.serviceCatalogProvisioningDetails) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Project = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Who created the project.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * A timestamp specifying when the project was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * A timestamp container for when the project was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the project.
         */
        public var projectArn: kotlin.String? = null
        /**
         * The description of the project.
         */
        public var projectDescription: kotlin.String? = null
        /**
         * The ID of the project.
         */
        public var projectId: kotlin.String? = null
        /**
         * The name of the project.
         */
        public var projectName: kotlin.String? = null
        /**
         * The status of the project.
         */
        public var projectStatus: aws.sdk.kotlin.services.sagemaker.model.ProjectStatus? = null
        /**
         * Details of a provisioned service catalog product. For information about service catalog, see [What is Amazon Web Services Service Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
         */
        public var serviceCatalogProvisionedProductDetails: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails? = null
        /**
         * Details that you specify to provision a service catalog product. For information about service catalog, see [What is Amazon Web Services Service Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
         */
        public var serviceCatalogProvisioningDetails: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Project) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.projectArn = x.projectArn
            this.projectDescription = x.projectDescription
            this.projectId = x.projectId
            this.projectName = x.projectName
            this.projectStatus = x.projectStatus
            this.serviceCatalogProvisionedProductDetails = x.serviceCatalogProvisionedProductDetails
            this.serviceCatalogProvisioningDetails = x.serviceCatalogProvisioningDetails
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Project = Project(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails] inside the given [block]
         */
        public fun serviceCatalogProvisionedProductDetails(block: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails.Builder.() -> kotlin.Unit) {
            this.serviceCatalogProvisionedProductDetails = aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisionedProductDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails] inside the given [block]
         */
        public fun serviceCatalogProvisioningDetails(block: aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails.Builder.() -> kotlin.Unit) {
            this.serviceCatalogProvisioningDetails = aws.sdk.kotlin.services.sagemaker.model.ServiceCatalogProvisioningDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
