// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration information for updating the Amazon SageMaker Debugger profile parameters, system and framework metrics configurations, and storage paths.
 */
public class ProfilerConfigForUpdate private constructor(builder: Builder) {
    /**
     * To turn off Amazon SageMaker Debugger monitoring and profiling while a training job is in progress, set to `True`.
     */
    public val disableProfiler: kotlin.Boolean? = builder.disableProfiler
    /**
     * A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.
     */
    public val profilingIntervalInMilliseconds: kotlin.Long? = builder.profilingIntervalInMilliseconds
    /**
     * Configuration information for capturing framework metrics. Available key strings for different profiling options are `DetailedProfilingConfig`, `PythonProfilingConfig`, and `DataLoaderProfilingConfig`. The following codes are configuration structures for the `ProfilingParameters` parameter. To learn more about how to configure the `ProfilingParameters` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
     */
    public val profilingParameters: Map<String, String>? = builder.profilingParameters
    /**
     * Path to Amazon S3 storage location for system and framework metrics.
     */
    public val s3OutputPath: kotlin.String? = builder.s3OutputPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProfilerConfigForUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilerConfigForUpdate(")
        append("disableProfiler=$disableProfiler,")
        append("profilingIntervalInMilliseconds=$profilingIntervalInMilliseconds,")
        append("profilingParameters=$profilingParameters,")
        append("s3OutputPath=$s3OutputPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableProfiler?.hashCode() ?: 0
        result = 31 * result + (profilingIntervalInMilliseconds?.hashCode() ?: 0)
        result = 31 * result + (profilingParameters?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProfilerConfigForUpdate

        if (disableProfiler != other.disableProfiler) return false
        if (profilingIntervalInMilliseconds != other.profilingIntervalInMilliseconds) return false
        if (profilingParameters != other.profilingParameters) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProfilerConfigForUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * To turn off Amazon SageMaker Debugger monitoring and profiling while a training job is in progress, set to `True`.
         */
        public var disableProfiler: kotlin.Boolean? = null
        /**
         * A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.
         */
        public var profilingIntervalInMilliseconds: kotlin.Long? = null
        /**
         * Configuration information for capturing framework metrics. Available key strings for different profiling options are `DetailedProfilingConfig`, `PythonProfilingConfig`, and `DataLoaderProfilingConfig`. The following codes are configuration structures for the `ProfilingParameters` parameter. To learn more about how to configure the `ProfilingParameters` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
         */
        public var profilingParameters: Map<String, String>? = null
        /**
         * Path to Amazon S3 storage location for system and framework metrics.
         */
        public var s3OutputPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfigForUpdate) : this() {
            this.disableProfiler = x.disableProfiler
            this.profilingIntervalInMilliseconds = x.profilingIntervalInMilliseconds
            this.profilingParameters = x.profilingParameters
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProfilerConfigForUpdate = ProfilerConfigForUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
