// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon SageMaker processing job that is used to analyze data and evaluate models. For more information, see [Process Data and Evaluate Models](https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html).
 */
public class ProcessingJob private constructor(builder: Builder) {
    /**
     * Configuration to run a processing job in a specified container image.
     */
    public val appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = builder.appSpecification
    /**
     * The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.
     */
    public val autoMlJobArn: kotlin.String? = builder.autoMlJobArn
    /**
     * The time the processing job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Sets the environment variables in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.
     */
    public val exitMessage: kotlin.String? = builder.exitMessage
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
     * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
     * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
     */
    public val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The time the processing job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The ARN of a monitoring schedule for an endpoint associated with this processing job.
     */
    public val monitoringScheduleArn: kotlin.String? = builder.monitoringScheduleArn
    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     */
    public val networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = builder.networkConfig
    /**
     * The time that the processing job ended.
     */
    public val processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.processingEndTime
    /**
     * List of input configurations for the processing job.
     */
    public val processingInputs: List<ProcessingInput>? = builder.processingInputs
    /**
     * The ARN of the processing job.
     */
    public val processingJobArn: kotlin.String? = builder.processingJobArn
    /**
     * The name of the processing job.
     */
    public val processingJobName: kotlin.String? = builder.processingJobName
    /**
     * The status of the processing job.
     */
    public val processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = builder.processingJobStatus
    /**
     * Configuration for uploading output from the processing container.
     */
    public val processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = builder.processingOutputConfig
    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.
     */
    public val processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = builder.processingResources
    /**
     * The time that the processing job started.
     */
    public val processingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.processingStartTime
    /**
     * The ARN of the role used to create the processing job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. After the condition is met, the processing job is stopped.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = builder.stoppingCondition
    /**
     * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ARN of the training job associated with this processing job.
     */
    public val trainingJobArn: kotlin.String? = builder.trainingJobArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingJob(")
        append("appSpecification=$appSpecification,")
        append("autoMlJobArn=$autoMlJobArn,")
        append("creationTime=$creationTime,")
        append("environment=$environment,")
        append("exitMessage=$exitMessage,")
        append("experimentConfig=$experimentConfig,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("monitoringScheduleArn=$monitoringScheduleArn,")
        append("networkConfig=$networkConfig,")
        append("processingEndTime=$processingEndTime,")
        append("processingInputs=$processingInputs,")
        append("processingJobArn=$processingJobArn,")
        append("processingJobName=$processingJobName,")
        append("processingJobStatus=$processingJobStatus,")
        append("processingOutputConfig=$processingOutputConfig,")
        append("processingResources=$processingResources,")
        append("processingStartTime=$processingStartTime,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags,")
        append("trainingJobArn=$trainingJobArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSpecification?.hashCode() ?: 0
        result = 31 * result + (autoMlJobArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (exitMessage?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleArn?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (processingEndTime?.hashCode() ?: 0)
        result = 31 * result + (processingInputs?.hashCode() ?: 0)
        result = 31 * result + (processingJobArn?.hashCode() ?: 0)
        result = 31 * result + (processingJobName?.hashCode() ?: 0)
        result = 31 * result + (processingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (processingOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (processingResources?.hashCode() ?: 0)
        result = 31 * result + (processingStartTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingJob

        if (appSpecification != other.appSpecification) return false
        if (autoMlJobArn != other.autoMlJobArn) return false
        if (creationTime != other.creationTime) return false
        if (environment != other.environment) return false
        if (exitMessage != other.exitMessage) return false
        if (experimentConfig != other.experimentConfig) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (monitoringScheduleArn != other.monitoringScheduleArn) return false
        if (networkConfig != other.networkConfig) return false
        if (processingEndTime != other.processingEndTime) return false
        if (processingInputs != other.processingInputs) return false
        if (processingJobArn != other.processingJobArn) return false
        if (processingJobName != other.processingJobName) return false
        if (processingJobStatus != other.processingJobStatus) return false
        if (processingOutputConfig != other.processingOutputConfig) return false
        if (processingResources != other.processingResources) return false
        if (processingStartTime != other.processingStartTime) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false
        if (trainingJobArn != other.trainingJobArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration to run a processing job in a specified container image.
         */
        public var appSpecification: aws.sdk.kotlin.services.sagemaker.model.AppSpecification? = null
        /**
         * The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.
         */
        public var autoMlJobArn: kotlin.String? = null
        /**
         * The time the processing job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Sets the environment variables in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.
         */
        public var exitMessage: kotlin.String? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
         * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
         * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
         */
        public var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The time the processing job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of a monitoring schedule for an endpoint associated with this processing job.
         */
        public var monitoringScheduleArn: kotlin.String? = null
        /**
         * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
         */
        public var networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = null
        /**
         * The time that the processing job ended.
         */
        public var processingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of input configurations for the processing job.
         */
        public var processingInputs: List<ProcessingInput>? = null
        /**
         * The ARN of the processing job.
         */
        public var processingJobArn: kotlin.String? = null
        /**
         * The name of the processing job.
         */
        public var processingJobName: kotlin.String? = null
        /**
         * The status of the processing job.
         */
        public var processingJobStatus: aws.sdk.kotlin.services.sagemaker.model.ProcessingJobStatus? = null
        /**
         * Configuration for uploading output from the processing container.
         */
        public var processingOutputConfig: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig? = null
        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.
         */
        public var processingResources: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources? = null
        /**
         * The time that the processing job started.
         */
        public var processingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the role used to create the processing job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. After the condition is met, the processing job is stopped.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition? = null
        /**
         * An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The ARN of the training job associated with this processing job.
         */
        public var trainingJobArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingJob) : this() {
            this.appSpecification = x.appSpecification
            this.autoMlJobArn = x.autoMlJobArn
            this.creationTime = x.creationTime
            this.environment = x.environment
            this.exitMessage = x.exitMessage
            this.experimentConfig = x.experimentConfig
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.monitoringScheduleArn = x.monitoringScheduleArn
            this.networkConfig = x.networkConfig
            this.processingEndTime = x.processingEndTime
            this.processingInputs = x.processingInputs
            this.processingJobArn = x.processingJobArn
            this.processingJobName = x.processingJobName
            this.processingJobStatus = x.processingJobStatus
            this.processingOutputConfig = x.processingOutputConfig
            this.processingResources = x.processingResources
            this.processingStartTime = x.processingStartTime
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
            this.trainingJobArn = x.trainingJobArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingJob = ProcessingJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AppSpecification] inside the given [block]
         */
        public fun appSpecification(block: aws.sdk.kotlin.services.sagemaker.model.AppSpecification.Builder.() -> kotlin.Unit) {
            this.appSpecification = aws.sdk.kotlin.services.sagemaker.model.AppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        public fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NetworkConfig] inside the given [block]
         */
        public fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig] inside the given [block]
         */
        public fun processingOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.Builder.() -> kotlin.Unit) {
            this.processingOutputConfig = aws.sdk.kotlin.services.sagemaker.model.ProcessingOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingResources] inside the given [block]
         */
        public fun processingResources(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.Builder.() -> kotlin.Unit) {
            this.processingResources = aws.sdk.kotlin.services.sagemaker.model.ProcessingResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.ProcessingStoppingCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
