// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Summary of the deployment configuration of a model.
 */
public class ModelVariantConfigSummary private constructor(builder: Builder) {
    /**
     * The configuration of the infrastructure that the model has been deployed to.
     */
    public val infrastructureConfig: aws.sdk.kotlin.services.sagemaker.model.ModelInfrastructureConfig? = builder.infrastructureConfig
    /**
     * The name of the Amazon SageMaker Model entity.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The status of deployment for the model variant on the hosted inference endpoint.
     * + `Creating` - Amazon SageMaker is preparing the model variant on the hosted inference endpoint.
     * + `InService` - The model variant is running on the hosted inference endpoint.
     * + `Updating` - Amazon SageMaker is updating the model variant on the hosted inference endpoint.
     * + `Deleting` - Amazon SageMaker is deleting the model variant on the hosted inference endpoint.
     * + `Deleted` - The model variant has been deleted on the hosted inference endpoint. This can only happen after stopping the experiment.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.ModelVariantStatus? = builder.status
    /**
     * The name of the variant.
     */
    public val variantName: kotlin.String? = builder.variantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelVariantConfigSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelVariantConfigSummary(")
        append("infrastructureConfig=$infrastructureConfig,")
        append("modelName=$modelName,")
        append("status=$status,")
        append("variantName=$variantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = infrastructureConfig?.hashCode() ?: 0
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelVariantConfigSummary

        if (infrastructureConfig != other.infrastructureConfig) return false
        if (modelName != other.modelName) return false
        if (status != other.status) return false
        if (variantName != other.variantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelVariantConfigSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration of the infrastructure that the model has been deployed to.
         */
        public var infrastructureConfig: aws.sdk.kotlin.services.sagemaker.model.ModelInfrastructureConfig? = null
        /**
         * The name of the Amazon SageMaker Model entity.
         */
        public var modelName: kotlin.String? = null
        /**
         * The status of deployment for the model variant on the hosted inference endpoint.
         * + `Creating` - Amazon SageMaker is preparing the model variant on the hosted inference endpoint.
         * + `InService` - The model variant is running on the hosted inference endpoint.
         * + `Updating` - Amazon SageMaker is updating the model variant on the hosted inference endpoint.
         * + `Deleting` - Amazon SageMaker is deleting the model variant on the hosted inference endpoint.
         * + `Deleted` - The model variant has been deleted on the hosted inference endpoint. This can only happen after stopping the experiment.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.ModelVariantStatus? = null
        /**
         * The name of the variant.
         */
        public var variantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelVariantConfigSummary) : this() {
            this.infrastructureConfig = x.infrastructureConfig
            this.modelName = x.modelName
            this.status = x.status
            this.variantName = x.variantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelVariantConfigSummary = ModelVariantConfigSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelInfrastructureConfig] inside the given [block]
         */
        public fun infrastructureConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelInfrastructureConfig.Builder.() -> kotlin.Unit) {
            this.infrastructureConfig = aws.sdk.kotlin.services.sagemaker.model.ModelInfrastructureConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
