// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a model package.
 */
public class ModelPackageSummary private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the model package was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The approval status of the model. This can be one of the following values.
     * + `APPROVED` - The model is approved
     * + `REJECTED` - The model is rejected.
     * + `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
     */
    public val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * The Amazon Resource Name (ARN) of the model package.
     */
    public val modelPackageArn: kotlin.String? = builder.modelPackageArn
    /**
     * A brief description of the model package.
     */
    public val modelPackageDescription: kotlin.String? = builder.modelPackageDescription
    /**
     * If the model package is a versioned model, the model group that the versioned model belongs to.
     */
    public val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The name of the model package.
     */
    public val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * The overall status of the model package.
     */
    public val modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = builder.modelPackageStatus
    /**
     * If the model package is a versioned model, the version of the model.
     */
    public val modelPackageVersion: kotlin.Int? = builder.modelPackageVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackageSummary(")
        append("creationTime=$creationTime,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelPackageArn=$modelPackageArn,")
        append("modelPackageDescription=$modelPackageDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageName=$modelPackageName,")
        append("modelPackageStatus=$modelPackageStatus,")
        append("modelPackageVersion=$modelPackageVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelPackageArn?.hashCode() ?: 0)
        result = 31 * result + (modelPackageDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageStatus?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersion ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackageSummary

        if (creationTime != other.creationTime) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelPackageArn != other.modelPackageArn) return false
        if (modelPackageDescription != other.modelPackageDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageName != other.modelPackageName) return false
        if (modelPackageStatus != other.modelPackageStatus) return false
        if (modelPackageVersion != other.modelPackageVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackageSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp that shows when the model package was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The approval status of the model. This can be one of the following values.
         * + `APPROVED` - The model is approved
         * + `REJECTED` - The model is rejected.
         * + `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
         */
        public var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the model package.
         */
        public var modelPackageArn: kotlin.String? = null
        /**
         * A brief description of the model package.
         */
        public var modelPackageDescription: kotlin.String? = null
        /**
         * If the model package is a versioned model, the model group that the versioned model belongs to.
         */
        public var modelPackageGroupName: kotlin.String? = null
        /**
         * The name of the model package.
         */
        public var modelPackageName: kotlin.String? = null
        /**
         * The overall status of the model package.
         */
        public var modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = null
        /**
         * If the model package is a versioned model, the version of the model.
         */
        public var modelPackageVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackageSummary) : this() {
            this.creationTime = x.creationTime
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelPackageArn = x.modelPackageArn
            this.modelPackageDescription = x.modelPackageDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageName = x.modelPackageName
            this.modelPackageStatus = x.modelPackageStatus
            this.modelPackageVersion = x.modelPackageVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackageSummary = ModelPackageSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
