// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of a specific version of the model card.
 */
public class ModelCardVersionSummary private constructor(builder: Builder) {
    /**
     * The date and time that the model card version was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time date and time that the model card version was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the model card.
     */
    public val modelCardArn: kotlin.String? = builder.modelCardArn
    /**
     * The name of the model card.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The approval status of the model card version within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus
    /**
     * A version of the model card.
     */
    public val modelCardVersion: kotlin.Int? = builder.modelCardVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelCardVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelCardVersionSummary(")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelCardArn=$modelCardArn,")
        append("modelCardName=$modelCardName,")
        append("modelCardStatus=$modelCardStatus,")
        append("modelCardVersion=$modelCardVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelCardArn?.hashCode() ?: 0)
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        result = 31 * result + (modelCardVersion ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelCardVersionSummary

        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelCardArn != other.modelCardArn) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardStatus != other.modelCardStatus) return false
        if (modelCardVersion != other.modelCardVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelCardVersionSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the model card version was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time date and time that the model card version was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model card.
         */
        public var modelCardArn: kotlin.String? = null
        /**
         * The name of the model card.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The approval status of the model card version within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null
        /**
         * A version of the model card.
         */
        public var modelCardVersion: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelCardVersionSummary) : this() {
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
            this.modelCardArn = x.modelCardArn
            this.modelCardName = x.modelCardName
            this.modelCardStatus = x.modelCardStatus
            this.modelCardVersion = x.modelCardVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelCardVersionSummary = ModelCardVersionSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
