// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListInferenceComponentsRequest private constructor(builder: Builder) {
    /**
     * Filters the results to only those inference components that were created after the specified time.
     */
    public val creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeAfter
    /**
     * Filters the results to only those inference components that were created before the specified time.
     */
    public val creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeBefore
    /**
     * An endpoint name to filter the listed inference components. The response includes only those inference components that are hosted at the specified endpoint.
     */
    public val endpointNameEquals: kotlin.String? = builder.endpointNameEquals
    /**
     * Filters the results to only those inference components that were updated after the specified time.
     */
    public val lastModifiedTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimeAfter
    /**
     * Filters the results to only those inference components that were updated before the specified time.
     */
    public val lastModifiedTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTimeBefore
    /**
     * The maximum number of inference components to return in the response. This value defaults to 10.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Filters the results to only those inference components with a name that contains the specified string.
     */
    public val nameContains: kotlin.String? = builder.nameContains
    /**
     * A token that you use to get the next set of results following a truncated response. If the response to the previous request was truncated, that response provides the value for this token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The field by which to sort the inference components in the response. The default is `CreationTime`.
     */
    public val sortBy: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSortKey? = builder.sortBy
    /**
     * The sort order for results. The default is `Descending`.
     */
    public val sortOrder: aws.sdk.kotlin.services.sagemaker.model.OrderKey? = builder.sortOrder
    /**
     * Filters the results to only those inference components with the specified status.
     */
    public val statusEquals: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStatus? = builder.statusEquals
    /**
     * A production variant name to filter the listed inference components. The response includes only those inference components that are hosted at the specified variant.
     */
    public val variantNameEquals: kotlin.String? = builder.variantNameEquals

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ListInferenceComponentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListInferenceComponentsRequest(")
        append("creationTimeAfter=$creationTimeAfter,")
        append("creationTimeBefore=$creationTimeBefore,")
        append("endpointNameEquals=$endpointNameEquals,")
        append("lastModifiedTimeAfter=$lastModifiedTimeAfter,")
        append("lastModifiedTimeBefore=$lastModifiedTimeBefore,")
        append("maxResults=$maxResults,")
        append("nameContains=$nameContains,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder,")
        append("statusEquals=$statusEquals,")
        append("variantNameEquals=$variantNameEquals")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimeAfter?.hashCode() ?: 0
        result = 31 * result + (creationTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (endpointNameEquals?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimeAfter?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nameContains?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        result = 31 * result + (statusEquals?.hashCode() ?: 0)
        result = 31 * result + (variantNameEquals?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListInferenceComponentsRequest

        if (creationTimeAfter != other.creationTimeAfter) return false
        if (creationTimeBefore != other.creationTimeBefore) return false
        if (endpointNameEquals != other.endpointNameEquals) return false
        if (lastModifiedTimeAfter != other.lastModifiedTimeAfter) return false
        if (lastModifiedTimeBefore != other.lastModifiedTimeBefore) return false
        if (maxResults != other.maxResults) return false
        if (nameContains != other.nameContains) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false
        if (statusEquals != other.statusEquals) return false
        if (variantNameEquals != other.variantNameEquals) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ListInferenceComponentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters the results to only those inference components that were created after the specified time.
         */
        public var creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Filters the results to only those inference components that were created before the specified time.
         */
        public var creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An endpoint name to filter the listed inference components. The response includes only those inference components that are hosted at the specified endpoint.
         */
        public var endpointNameEquals: kotlin.String? = null
        /**
         * Filters the results to only those inference components that were updated after the specified time.
         */
        public var lastModifiedTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Filters the results to only those inference components that were updated before the specified time.
         */
        public var lastModifiedTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of inference components to return in the response. This value defaults to 10.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Filters the results to only those inference components with a name that contains the specified string.
         */
        public var nameContains: kotlin.String? = null
        /**
         * A token that you use to get the next set of results following a truncated response. If the response to the previous request was truncated, that response provides the value for this token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The field by which to sort the inference components in the response. The default is `CreationTime`.
         */
        public var sortBy: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSortKey? = null
        /**
         * The sort order for results. The default is `Descending`.
         */
        public var sortOrder: aws.sdk.kotlin.services.sagemaker.model.OrderKey? = null
        /**
         * Filters the results to only those inference components with the specified status.
         */
        public var statusEquals: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStatus? = null
        /**
         * A production variant name to filter the listed inference components. The response includes only those inference components that are hosted at the specified variant.
         */
        public var variantNameEquals: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ListInferenceComponentsRequest) : this() {
            this.creationTimeAfter = x.creationTimeAfter
            this.creationTimeBefore = x.creationTimeBefore
            this.endpointNameEquals = x.endpointNameEquals
            this.lastModifiedTimeAfter = x.lastModifiedTimeAfter
            this.lastModifiedTimeBefore = x.lastModifiedTimeBefore
            this.maxResults = x.maxResults
            this.nameContains = x.nameContains
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
            this.statusEquals = x.statusEquals
            this.variantNameEquals = x.variantNameEquals
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ListInferenceComponentsRequest = ListInferenceComponentsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
