// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a labeling job.
 */
public class LabelingJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see [Annotation Consolidation](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
     */
    public val annotationConsolidationLambdaArn: kotlin.String? = builder.annotationConsolidationLambdaArn
    /**
     * The date and time that the job was created (timestamp).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If the `LabelingJobStatus` field is `Failed`, this field contains a description of the error.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Input configuration for the labeling job.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = builder.inputConfig
    /**
     * Counts showing the progress of the labeling job.
     */
    public val labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCounters? = builder.labelCounters
    /**
     * The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
     */
    public val labelingJobArn: kotlin.String? = builder.labelingJobArn
    /**
     * The name of the labeling job.
     */
    public val labelingJobName: kotlin.String? = builder.labelingJobName
    /**
     * The location of the output produced by the labeling job.
     */
    public val labelingJobOutput: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput? = builder.labelingJobOutput
    /**
     * The current status of the labeling job.
     */
    public val labelingJobStatus: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStatus? = builder.labelingJobStatus
    /**
     * The date and time that the job was last modified (timestamp).
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.
     */
    public val preHumanTaskLambdaArn: kotlin.String? = builder.preHumanTaskLambdaArn
    /**
     * The Amazon Resource Name (ARN) of the work team assigned to the job.
     */
    public val workteamArn: kotlin.String? = builder.workteamArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobSummary(")
        append("annotationConsolidationLambdaArn=$annotationConsolidationLambdaArn,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("inputConfig=$inputConfig,")
        append("labelCounters=$labelCounters,")
        append("labelingJobArn=$labelingJobArn,")
        append("labelingJobName=$labelingJobName,")
        append("labelingJobOutput=$labelingJobOutput,")
        append("labelingJobStatus=$labelingJobStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("preHumanTaskLambdaArn=$preHumanTaskLambdaArn,")
        append("workteamArn=$workteamArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = annotationConsolidationLambdaArn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (labelCounters?.hashCode() ?: 0)
        result = 31 * result + (labelingJobArn?.hashCode() ?: 0)
        result = 31 * result + (labelingJobName?.hashCode() ?: 0)
        result = 31 * result + (labelingJobOutput?.hashCode() ?: 0)
        result = 31 * result + (labelingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (preHumanTaskLambdaArn?.hashCode() ?: 0)
        result = 31 * result + (workteamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobSummary

        if (annotationConsolidationLambdaArn != other.annotationConsolidationLambdaArn) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (inputConfig != other.inputConfig) return false
        if (labelCounters != other.labelCounters) return false
        if (labelingJobArn != other.labelingJobArn) return false
        if (labelingJobName != other.labelingJobName) return false
        if (labelingJobOutput != other.labelingJobOutput) return false
        if (labelingJobStatus != other.labelingJobStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (preHumanTaskLambdaArn != other.preHumanTaskLambdaArn) return false
        if (workteamArn != other.workteamArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see [Annotation Consolidation](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
         */
        public var annotationConsolidationLambdaArn: kotlin.String? = null
        /**
         * The date and time that the job was created (timestamp).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the `LabelingJobStatus` field is `Failed`, this field contains a description of the error.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Input configuration for the labeling job.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig? = null
        /**
         * Counts showing the progress of the labeling job.
         */
        public var labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCounters? = null
        /**
         * The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
         */
        public var labelingJobArn: kotlin.String? = null
        /**
         * The name of the labeling job.
         */
        public var labelingJobName: kotlin.String? = null
        /**
         * The location of the output produced by the labeling job.
         */
        public var labelingJobOutput: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput? = null
        /**
         * The current status of the labeling job.
         */
        public var labelingJobStatus: aws.sdk.kotlin.services.sagemaker.model.LabelingJobStatus? = null
        /**
         * The date and time that the job was last modified (timestamp).
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.
         */
        public var preHumanTaskLambdaArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the work team assigned to the job.
         */
        public var workteamArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobSummary) : this() {
            this.annotationConsolidationLambdaArn = x.annotationConsolidationLambdaArn
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.inputConfig = x.inputConfig
            this.labelCounters = x.labelCounters
            this.labelingJobArn = x.labelingJobArn
            this.labelingJobName = x.labelingJobName
            this.labelingJobOutput = x.labelingJobOutput
            this.labelingJobStatus = x.labelingJobStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.preHumanTaskLambdaArn = x.preHumanTaskLambdaArn
            this.workteamArn = x.workteamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobSummary = LabelingJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobInputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelCounters] inside the given [block]
         */
        public fun labelCounters(block: aws.sdk.kotlin.services.sagemaker.model.LabelCounters.Builder.() -> kotlin.Unit) {
            this.labelCounters = aws.sdk.kotlin.services.sagemaker.model.LabelCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput] inside the given [block]
         */
        public fun labelingJobOutput(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput.Builder.() -> kotlin.Unit) {
            this.labelingJobOutput = aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
