// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The Amazon S3 location and configuration for storing inference request and response data.
 */
public class InferenceExperimentDataStorageConfig private constructor(builder: Builder) {
    /**
     * Configuration specifying how to treat different headers. If no headers are specified Amazon SageMaker will by default base64 encode when capturing the data.
     */
    public val contentType: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader? = builder.contentType
    /**
     * The Amazon S3 bucket where the inference request and response data is stored.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceExperimentDataStorageConfig(")
        append("contentType=$contentType,")
        append("destination=$destination,")
        append("kmsKey=$kmsKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceExperimentDataStorageConfig

        if (contentType != other.contentType) return false
        if (destination != other.destination) return false
        if (kmsKey != other.kmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration specifying how to treat different headers. If no headers are specified Amazon SageMaker will by default base64 encode when capturing the data.
         */
        public var contentType: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader? = null
        /**
         * The Amazon S3 bucket where the inference request and response data is stored.
         */
        public var destination: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
         */
        public var kmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig) : this() {
            this.contentType = x.contentType
            this.destination = x.destination
            this.kmsKey = x.kmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentDataStorageConfig = InferenceExperimentDataStorageConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader] inside the given [block]
         */
        public fun contentType(block: aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader.Builder.() -> kotlin.Unit) {
            this.contentType = aws.sdk.kotlin.services.sagemaker.model.CaptureContentTypeHeader.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
