// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value. Resources that match the statement are returned in the results from the [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API.
 *
 * If you specify a `Value`, but not an `Operator`, SageMaker uses the equals operator.
 *
 * In search, there are several property types:
 *
 * ## Metrics
 * To define a metric filter, enter a value using the form `"Metrics.<name>"`, where `<name>` is a metric name. For example, the following filter searches for training jobs with an `"accuracy"` metric greater than `"0.9"`:
 *
 * `{`
 *
 * `"Name": "Metrics.accuracy",`
 *
 * `"Operator": "GreaterThan",`
 *
 * `"Value": "0.9"`
 *
 * `}`
 *
 * ## HyperParameters
 * To define a hyperparameter filter, enter a value with the form `"HyperParameters.<name>"`. Decimal hyperparameter values are treated as a decimal in a comparison if the specified `Value` is also a decimal value. If the specified `Value` is an integer, the decimal hyperparameter values are treated as integers. For example, the following filter is satisfied by training jobs with a `"learning_rate"` hyperparameter that is less than `"0.5"`:
 *
 * ` {`
 *
 * ` "Name": "HyperParameters.learning_rate",`
 *
 * ` "Operator": "LessThan",`
 *
 * ` "Value": "0.5"`
 *
 * ` }`
 *
 * ## Tags
 * To define a tag filter, enter a value with the form `Tags.<key>`.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * A resource property name. For example, `TrainingJobName`. For valid property names, see [SearchRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html). You must specify a valid property for the resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:
     *
     * ## Equals
     * The value of `Name` equals `Value`.
     *
     * ## NotEquals
     * The value of `Name` doesn't equal `Value`.
     *
     * ## Exists
     * The `Name` property exists.
     *
     * ## NotExists
     * The `Name` property does not exist.
     *
     * ## GreaterThan
     * The value of `Name` is greater than `Value`. Not supported for text properties.
     *
     * ## GreaterThanOrEqualTo
     * The value of `Name` is greater than or equal to `Value`. Not supported for text properties.
     *
     * ## LessThan
     * The value of `Name` is less than `Value`. Not supported for text properties.
     *
     * ## LessThanOrEqualTo
     * The value of `Name` is less than or equal to `Value`. Not supported for text properties.
     *
     * ## In
     * The value of `Name` is one of the comma delimited strings in `Value`. Only supported for text properties.
     *
     * ## Contains
     * The value of `Name` contains the string `Value`. Only supported for text properties.
     *
     * A `SearchExpression` can include the `Contains` operator multiple times when the value of `Name` is one of the following:
     * + `Experiment.DisplayName`
     * + `Experiment.ExperimentName`
     * + `Experiment.Tags`
     * + `Trial.DisplayName`
     * + `Trial.TrialName`
     * + `Trial.Tags`
     * + `TrialComponent.DisplayName`
     * + `TrialComponent.TrialComponentName`
     * + `TrialComponent.Tags`
     * + `TrialComponent.InputArtifacts`
     * + `TrialComponent.OutputArtifacts`
     * A `SearchExpression` can include only one `Contains` operator for all other values of `Name`. In these cases, if you include multiple `Contains` operators in the `SearchExpression`, the result is the following error message: "`'CONTAINS' operator usage limit of 1 exceeded.`"
     */
    public val operator: aws.sdk.kotlin.services.sagemaker.model.Operator? = builder.operator
    /**
     * A value used with `Name` and `Operator` to determine which resources satisfy the filter's condition. For numerical properties, `Value` must be an integer or floating-point decimal. For timestamp properties, `Value` must be an ISO 8601 date-time string of the following format: `YYYY-mm-dd'T'HH:MM:SS`.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("name=$name,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Filter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A resource property name. For example, `TrainingJobName`. For valid property names, see [SearchRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html). You must specify a valid property for the resource.
         */
        public var name: kotlin.String? = null
        /**
         * A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:
         *
         * ## Equals
         * The value of `Name` equals `Value`.
         *
         * ## NotEquals
         * The value of `Name` doesn't equal `Value`.
         *
         * ## Exists
         * The `Name` property exists.
         *
         * ## NotExists
         * The `Name` property does not exist.
         *
         * ## GreaterThan
         * The value of `Name` is greater than `Value`. Not supported for text properties.
         *
         * ## GreaterThanOrEqualTo
         * The value of `Name` is greater than or equal to `Value`. Not supported for text properties.
         *
         * ## LessThan
         * The value of `Name` is less than `Value`. Not supported for text properties.
         *
         * ## LessThanOrEqualTo
         * The value of `Name` is less than or equal to `Value`. Not supported for text properties.
         *
         * ## In
         * The value of `Name` is one of the comma delimited strings in `Value`. Only supported for text properties.
         *
         * ## Contains
         * The value of `Name` contains the string `Value`. Only supported for text properties.
         *
         * A `SearchExpression` can include the `Contains` operator multiple times when the value of `Name` is one of the following:
         * + `Experiment.DisplayName`
         * + `Experiment.ExperimentName`
         * + `Experiment.Tags`
         * + `Trial.DisplayName`
         * + `Trial.TrialName`
         * + `Trial.Tags`
         * + `TrialComponent.DisplayName`
         * + `TrialComponent.TrialComponentName`
         * + `TrialComponent.Tags`
         * + `TrialComponent.InputArtifacts`
         * + `TrialComponent.OutputArtifacts`
         * A `SearchExpression` can include only one `Contains` operator for all other values of `Name`. In these cases, if you include multiple `Contains` operators in the `SearchExpression`, the result is the following error message: "`'CONTAINS' operator usage limit of 1 exceeded.`"
         */
        public var operator: aws.sdk.kotlin.services.sagemaker.model.Operator? = null
        /**
         * A value used with `Name` and `Operator` to determine which resources satisfy the filter's condition. For numerical properties, `Value` must be an integer or floating-point decimal. For timestamp properties, `Value` must be an ISO 8601 date-time string of the following format: `YYYY-mm-dd'T'HH:MM:SS`.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Filter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
