// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The endpoint configuration made by Inference Recommender during a recommendation job.
 */
public class EndpointOutputConfiguration private constructor(builder: Builder) {
    /**
     * The name of the endpoint made during a recommendation job.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The number of instances recommended to launch initially.
     */
    public val initialInstanceCount: kotlin.Int? = builder.initialInstanceCount
    /**
     * The instance type recommended by Amazon SageMaker Inference Recommender.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = builder.instanceType
    /**
     * Specifies the serverless configuration for an endpoint variant.
     */
    public val serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.serverlessConfig
    /**
     * The name of the production variant (deployed model) made during a recommendation job.
     */
    public val variantName: kotlin.String? = builder.variantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EndpointOutputConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointOutputConfiguration(")
        append("endpointName=$endpointName,")
        append("initialInstanceCount=$initialInstanceCount,")
        append("instanceType=$instanceType,")
        append("serverlessConfig=$serverlessConfig,")
        append("variantName=$variantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointName?.hashCode() ?: 0
        result = 31 * result + (initialInstanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (serverlessConfig?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointOutputConfiguration

        if (endpointName != other.endpointName) return false
        if (initialInstanceCount != other.initialInstanceCount) return false
        if (instanceType != other.instanceType) return false
        if (serverlessConfig != other.serverlessConfig) return false
        if (variantName != other.variantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EndpointOutputConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the endpoint made during a recommendation job.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The number of instances recommended to launch initially.
         */
        public var initialInstanceCount: kotlin.Int? = null
        /**
         * The instance type recommended by Amazon SageMaker Inference Recommender.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = null
        /**
         * Specifies the serverless configuration for an endpoint variant.
         */
        public var serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The name of the production variant (deployed model) made during a recommendation job.
         */
        public var variantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EndpointOutputConfiguration) : this() {
            this.endpointName = x.endpointName
            this.initialInstanceCount = x.initialInstanceCount
            this.instanceType = x.instanceType
            this.serverlessConfig = x.serverlessConfig
            this.variantName = x.variantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EndpointOutputConfiguration = EndpointOutputConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        public fun serverlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.serverlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
