// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A hosted endpoint for real-time inference.
 */
public class Endpoint private constructor(builder: Builder) {
    /**
     * The time that the endpoint was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The currently active data capture configuration used by your Endpoint.
     */
    public val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary? = builder.dataCaptureConfig
    /**
     * The Amazon Resource Name (ARN) of the endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The endpoint configuration associated with the endpoint.
     */
    public val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * The name of the endpoint.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The status of the endpoint.
     */
    public val endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = builder.endpointStatus
    /**
     * If the endpoint failed, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The last time the endpoint was modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A list of monitoring schedules for the endpoint. For information about model monitoring, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
     */
    public val monitoringSchedules: List<MonitoringSchedule>? = builder.monitoringSchedules
    /**
     * A list of the production variants hosted on the endpoint. Each production variant is a model.
     */
    public val productionVariants: List<ProductionVariantSummary>? = builder.productionVariants
    /**
     * A list of the shadow variants hosted on the endpoint. Each shadow variant is a model in shadow mode with production traffic replicated from the production variant.
     */
    public val shadowProductionVariants: List<ProductionVariantSummary>? = builder.shadowProductionVariants
    /**
     * A list of the tags associated with the endpoint. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("creationTime=$creationTime,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("endpointArn=$endpointArn,")
        append("endpointConfigName=$endpointConfigName,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("monitoringSchedules=$monitoringSchedules,")
        append("productionVariants=$productionVariants,")
        append("shadowProductionVariants=$shadowProductionVariants,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (monitoringSchedules?.hashCode() ?: 0)
        result = 31 * result + (productionVariants?.hashCode() ?: 0)
        result = 31 * result + (shadowProductionVariants?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Endpoint

        if (creationTime != other.creationTime) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (monitoringSchedules != other.monitoringSchedules) return false
        if (productionVariants != other.productionVariants) return false
        if (shadowProductionVariants != other.shadowProductionVariants) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Endpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time that the endpoint was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The currently active data capture configuration used by your Endpoint.
         */
        public var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The endpoint configuration associated with the endpoint.
         */
        public var endpointConfigName: kotlin.String? = null
        /**
         * The name of the endpoint.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The status of the endpoint.
         */
        public var endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = null
        /**
         * If the endpoint failed, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The last time the endpoint was modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of monitoring schedules for the endpoint. For information about model monitoring, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
         */
        public var monitoringSchedules: List<MonitoringSchedule>? = null
        /**
         * A list of the production variants hosted on the endpoint. Each production variant is a model.
         */
        public var productionVariants: List<ProductionVariantSummary>? = null
        /**
         * A list of the shadow variants hosted on the endpoint. Each shadow variant is a model in shadow mode with production traffic replicated from the production variant.
         */
        public var shadowProductionVariants: List<ProductionVariantSummary>? = null
        /**
         * A list of the tags associated with the endpoint. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Endpoint) : this() {
            this.creationTime = x.creationTime
            this.dataCaptureConfig = x.dataCaptureConfig
            this.endpointArn = x.endpointArn
            this.endpointConfigName = x.endpointConfigName
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.monitoringSchedules = x.monitoringSchedules
            this.productionVariants = x.productionVariants
            this.shadowProductionVariants = x.shadowProductionVariants
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Endpoint = Endpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary] inside the given [block]
         */
        public fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.DataCaptureConfigSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
