// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeHyperParameterTuningJobResponse private constructor(builder: Builder) {
    /**
     * A flag to indicate if autotune is enabled for the hyperparameter tuning job.
     */
    public val autotune: aws.sdk.kotlin.services.sagemaker.model.Autotune? = builder.autotune
    /**
     * A [TrainingJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html) object that describes the training job that completed with the best current [HyperParameterTuningJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html).
     */
    public val bestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = builder.bestTrainingJob
    /**
     * The total resources consumed by your hyperparameter tuning job.
     */
    public val consumedResources: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources? = builder.consumedResources
    /**
     * The date and time that the tuning job started.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If the tuning job failed, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The date and time that the tuning job ended.
     */
    public val hyperParameterTuningEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.hyperParameterTuningEndTime
    /**
     * The Amazon Resource Name (ARN) of the tuning job.
     */
    public val hyperParameterTuningJobArn: kotlin.String? = builder.hyperParameterTuningJobArn
    /**
     * The [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html) object that specifies the configuration of the tuning job.
     */
    public val hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = builder.hyperParameterTuningJobConfig
    /**
     * The name of the hyperparameter tuning job.
     */
    public val hyperParameterTuningJobName: kotlin.String? = builder.hyperParameterTuningJobName
    /**
     * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
     */
    public val hyperParameterTuningJobStatus: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus? = builder.hyperParameterTuningJobStatus
    /**
     * The date and time that the status of the tuning job was modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The [ObjectiveStatusCounters](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ObjectiveStatusCounters.html) object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.
     */
    public val objectiveStatusCounters: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters? = builder.objectiveStatusCounters
    /**
     * If the hyperparameter tuning job is an warm start tuning job with a `WarmStartType` of `IDENTICAL_DATA_AND_ALGORITHM`, this is the [TrainingJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html) for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.
     */
    public val overallBestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = builder.overallBestTrainingJob
    /**
     * The [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) object that specifies the definition of the training jobs that this tuning job launches.
     */
    public val trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = builder.trainingJobDefinition
    /**
     * A list of the [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) objects launched for this tuning job.
     */
    public val trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = builder.trainingJobDefinitions
    /**
     * The [TrainingJobStatusCounters](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobStatusCounters.html) object that specifies the number of training jobs, categorized by status, that this tuning job launched.
     */
    public val trainingJobStatusCounters: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters? = builder.trainingJobStatusCounters
    /**
     * Tuning job completion information returned as the response from a hyperparameter tuning job. This information tells if your tuning job has or has not converged. It also includes the number of training jobs that have not improved model performance as evaluated against the objective function.
     */
    public val tuningJobCompletionDetails: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails? = builder.tuningJobCompletionDetails
    /**
     * The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
     */
    public val warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = builder.warmStartConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHyperParameterTuningJobResponse(")
        append("autotune=$autotune,")
        append("bestTrainingJob=$bestTrainingJob,")
        append("consumedResources=$consumedResources,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("hyperParameterTuningEndTime=$hyperParameterTuningEndTime,")
        append("hyperParameterTuningJobArn=$hyperParameterTuningJobArn,")
        append("hyperParameterTuningJobConfig=$hyperParameterTuningJobConfig,")
        append("hyperParameterTuningJobName=$hyperParameterTuningJobName,")
        append("hyperParameterTuningJobStatus=$hyperParameterTuningJobStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("objectiveStatusCounters=$objectiveStatusCounters,")
        append("overallBestTrainingJob=$overallBestTrainingJob,")
        append("trainingJobDefinition=$trainingJobDefinition,")
        append("trainingJobDefinitions=$trainingJobDefinitions,")
        append("trainingJobStatusCounters=$trainingJobStatusCounters,")
        append("tuningJobCompletionDetails=$tuningJobCompletionDetails,")
        append("warmStartConfig=$warmStartConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autotune?.hashCode() ?: 0
        result = 31 * result + (bestTrainingJob?.hashCode() ?: 0)
        result = 31 * result + (consumedResources?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningEndTime?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobArn?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobConfig?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobName?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (objectiveStatusCounters?.hashCode() ?: 0)
        result = 31 * result + (overallBestTrainingJob?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinition?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinitions?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatusCounters?.hashCode() ?: 0)
        result = 31 * result + (tuningJobCompletionDetails?.hashCode() ?: 0)
        result = 31 * result + (warmStartConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeHyperParameterTuningJobResponse

        if (autotune != other.autotune) return false
        if (bestTrainingJob != other.bestTrainingJob) return false
        if (consumedResources != other.consumedResources) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (hyperParameterTuningEndTime != other.hyperParameterTuningEndTime) return false
        if (hyperParameterTuningJobArn != other.hyperParameterTuningJobArn) return false
        if (hyperParameterTuningJobConfig != other.hyperParameterTuningJobConfig) return false
        if (hyperParameterTuningJobName != other.hyperParameterTuningJobName) return false
        if (hyperParameterTuningJobStatus != other.hyperParameterTuningJobStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (objectiveStatusCounters != other.objectiveStatusCounters) return false
        if (overallBestTrainingJob != other.overallBestTrainingJob) return false
        if (trainingJobDefinition != other.trainingJobDefinition) return false
        if (trainingJobDefinitions != other.trainingJobDefinitions) return false
        if (trainingJobStatusCounters != other.trainingJobStatusCounters) return false
        if (tuningJobCompletionDetails != other.tuningJobCompletionDetails) return false
        if (warmStartConfig != other.warmStartConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag to indicate if autotune is enabled for the hyperparameter tuning job.
         */
        public var autotune: aws.sdk.kotlin.services.sagemaker.model.Autotune? = null
        /**
         * A [TrainingJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html) object that describes the training job that completed with the best current [HyperParameterTuningJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html).
         */
        public var bestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = null
        /**
         * The total resources consumed by your hyperparameter tuning job.
         */
        public var consumedResources: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources? = null
        /**
         * The date and time that the tuning job started.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the tuning job failed, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The date and time that the tuning job ended.
         */
        public var hyperParameterTuningEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the tuning job.
         */
        public var hyperParameterTuningJobArn: kotlin.String? = null
        /**
         * The [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html) object that specifies the configuration of the tuning job.
         */
        public var hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = null
        /**
         * The name of the hyperparameter tuning job.
         */
        public var hyperParameterTuningJobName: kotlin.String? = null
        /**
         * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
         */
        public var hyperParameterTuningJobStatus: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus? = null
        /**
         * The date and time that the status of the tuning job was modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The [ObjectiveStatusCounters](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ObjectiveStatusCounters.html) object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.
         */
        public var objectiveStatusCounters: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters? = null
        /**
         * If the hyperparameter tuning job is an warm start tuning job with a `WarmStartType` of `IDENTICAL_DATA_AND_ALGORITHM`, this is the [TrainingJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html) for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.
         */
        public var overallBestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = null
        /**
         * The [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) object that specifies the definition of the training jobs that this tuning job launches.
         */
        public var trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = null
        /**
         * A list of the [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html) objects launched for this tuning job.
         */
        public var trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = null
        /**
         * The [TrainingJobStatusCounters](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobStatusCounters.html) object that specifies the number of training jobs, categorized by status, that this tuning job launched.
         */
        public var trainingJobStatusCounters: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters? = null
        /**
         * Tuning job completion information returned as the response from a hyperparameter tuning job. This information tells if your tuning job has or has not converged. It also includes the number of training jobs that have not improved model performance as evaluated against the objective function.
         */
        public var tuningJobCompletionDetails: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails? = null
        /**
         * The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
         */
        public var warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse) : this() {
            this.autotune = x.autotune
            this.bestTrainingJob = x.bestTrainingJob
            this.consumedResources = x.consumedResources
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.hyperParameterTuningEndTime = x.hyperParameterTuningEndTime
            this.hyperParameterTuningJobArn = x.hyperParameterTuningJobArn
            this.hyperParameterTuningJobConfig = x.hyperParameterTuningJobConfig
            this.hyperParameterTuningJobName = x.hyperParameterTuningJobName
            this.hyperParameterTuningJobStatus = x.hyperParameterTuningJobStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.objectiveStatusCounters = x.objectiveStatusCounters
            this.overallBestTrainingJob = x.overallBestTrainingJob
            this.trainingJobDefinition = x.trainingJobDefinition
            this.trainingJobDefinitions = x.trainingJobDefinitions
            this.trainingJobStatusCounters = x.trainingJobStatusCounters
            this.tuningJobCompletionDetails = x.tuningJobCompletionDetails
            this.warmStartConfig = x.warmStartConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse = DescribeHyperParameterTuningJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.Autotune] inside the given [block]
         */
        public fun autotune(block: aws.sdk.kotlin.services.sagemaker.model.Autotune.Builder.() -> kotlin.Unit) {
            this.autotune = aws.sdk.kotlin.services.sagemaker.model.Autotune.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary] inside the given [block]
         */
        public fun bestTrainingJob(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.Builder.() -> kotlin.Unit) {
            this.bestTrainingJob = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources] inside the given [block]
         */
        public fun consumedResources(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources.Builder.() -> kotlin.Unit) {
            this.consumedResources = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        public fun hyperParameterTuningJobConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters] inside the given [block]
         */
        public fun objectiveStatusCounters(block: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters.Builder.() -> kotlin.Unit) {
            this.objectiveStatusCounters = aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary] inside the given [block]
         */
        public fun overallBestTrainingJob(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.Builder.() -> kotlin.Unit) {
            this.overallBestTrainingJob = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition] inside the given [block]
         */
        public fun trainingJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder.() -> kotlin.Unit) {
            this.trainingJobDefinition = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters] inside the given [block]
         */
        public fun trainingJobStatusCounters(block: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters.Builder.() -> kotlin.Unit) {
            this.trainingJobStatusCounters = aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails] inside the given [block]
         */
        public fun tuningJobCompletionDetails(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails.Builder.() -> kotlin.Unit) {
            this.tuningJobCompletionDetails = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig] inside the given [block]
         */
        public fun warmStartConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.Builder.() -> kotlin.Unit) {
            this.warmStartConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
