// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreatePipelineRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.
     */
    public val parallelismConfiguration: aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration? = builder.parallelismConfiguration
    /**
     * The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    public val pipelineDefinition: kotlin.String? = builder.pipelineDefinition
    /**
     * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.
     */
    public val pipelineDefinitionS3Location: aws.sdk.kotlin.services.sagemaker.model.PipelineDefinitionS3Location? = builder.pipelineDefinitionS3Location
    /**
     * A description of the pipeline.
     */
    public val pipelineDescription: kotlin.String? = builder.pipelineDescription
    /**
     * The display name of the pipeline.
     */
    public val pipelineDisplayName: kotlin.String? = builder.pipelineDisplayName
    /**
     * The name of the pipeline.
     */
    public val pipelineName: kotlin.String? = builder.pipelineName
    /**
     * The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of tags to apply to the created pipeline.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreatePipelineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePipelineRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("parallelismConfiguration=$parallelismConfiguration,")
        append("pipelineDefinition=$pipelineDefinition,")
        append("pipelineDefinitionS3Location=$pipelineDefinitionS3Location,")
        append("pipelineDescription=$pipelineDescription,")
        append("pipelineDisplayName=$pipelineDisplayName,")
        append("pipelineName=$pipelineName,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (parallelismConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pipelineDefinition?.hashCode() ?: 0)
        result = 31 * result + (pipelineDefinitionS3Location?.hashCode() ?: 0)
        result = 31 * result + (pipelineDescription?.hashCode() ?: 0)
        result = 31 * result + (pipelineDisplayName?.hashCode() ?: 0)
        result = 31 * result + (pipelineName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePipelineRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (parallelismConfiguration != other.parallelismConfiguration) return false
        if (pipelineDefinition != other.pipelineDefinition) return false
        if (pipelineDefinitionS3Location != other.pipelineDefinitionS3Location) return false
        if (pipelineDescription != other.pipelineDescription) return false
        if (pipelineDisplayName != other.pipelineDisplayName) return false
        if (pipelineName != other.pipelineName) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreatePipelineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.
         */
        public var parallelismConfiguration: aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration? = null
        /**
         * The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
         */
        public var pipelineDefinition: kotlin.String? = null
        /**
         * The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.
         */
        public var pipelineDefinitionS3Location: aws.sdk.kotlin.services.sagemaker.model.PipelineDefinitionS3Location? = null
        /**
         * A description of the pipeline.
         */
        public var pipelineDescription: kotlin.String? = null
        /**
         * The display name of the pipeline.
         */
        public var pipelineDisplayName: kotlin.String? = null
        /**
         * The name of the pipeline.
         */
        public var pipelineName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of tags to apply to the created pipeline.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreatePipelineRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.parallelismConfiguration = x.parallelismConfiguration
            this.pipelineDefinition = x.pipelineDefinition
            this.pipelineDefinitionS3Location = x.pipelineDefinitionS3Location
            this.pipelineDescription = x.pipelineDescription
            this.pipelineDisplayName = x.pipelineDisplayName
            this.pipelineName = x.pipelineName
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreatePipelineRequest = CreatePipelineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration] inside the given [block]
         */
        public fun parallelismConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration.Builder.() -> kotlin.Unit) {
            this.parallelismConfiguration = aws.sdk.kotlin.services.sagemaker.model.ParallelismConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.PipelineDefinitionS3Location] inside the given [block]
         */
        public fun pipelineDefinitionS3Location(block: aws.sdk.kotlin.services.sagemaker.model.PipelineDefinitionS3Location.Builder.() -> kotlin.Unit) {
            this.pipelineDefinitionS3Location = aws.sdk.kotlin.services.sagemaker.model.PipelineDefinitionS3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
