// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateModelPackageRequest private constructor(builder: Builder) {
    /**
     * An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
     */
    public val additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = builder.additionalInferenceSpecifications
    /**
     * Whether to certify the model package for listing on Amazon Web Services Marketplace.
     *
     * This parameter is optional for unversioned models, and does not apply to versioned models.
     */
    public val certifyForMarketplace: kotlin.Boolean? = builder.certifyForMarketplace
    /**
     * A unique token that guarantees that the call to this API is idempotent.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The metadata properties associated with the model package versions.
     */
    public val customerMetadataProperties: Map<String, String>? = builder.customerMetadataProperties
    /**
     * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on [Drift Detection against Previous Baselines in SageMaker Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection) in the *Amazon SageMaker Developer Guide*.
     */
    public val driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = builder.driftCheckBaselines
    /**
     * Specifies details about inference jobs that can be run with models based on this model package, including the following:
     * + The Amazon ECR paths of containers that contain the inference code and model artifacts.
     * + The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
     * + The input and output content formats that the model package supports for inference.
     */
    public val inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = builder.inferenceSpecification
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    public val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * Whether the model is approved for deployment.
     *
     * This parameter is optional for versioned models, and does not apply to unversioned models.
     *
     * For versioned models, the value of this parameter must be set to `Approved` to deploy the model.
     */
    public val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * A structure that contains model metrics reports.
     */
    public val modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = builder.modelMetrics
    /**
     * A description of the model package.
     */
    public val modelPackageDescription: kotlin.String? = builder.modelPackageDescription
    /**
     * The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.
     *
     * This parameter is required for versioned models, and does not apply to unversioned models.
     */
    public val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
     *
     * This parameter is required for unversioned models. It is not applicable to versioned models.
     */
    public val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). This archive can hold multiple files that are all equally used in the load test. Each file in the archive must satisfy the size constraints of the [InvokeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html#API_runtime_InvokeEndpoint_RequestSyntax) call.
     */
    public val samplePayloadUrl: kotlin.String? = builder.samplePayloadUrl
    /**
     * Indicates if you want to skip model validation.
     */
    public val skipModelValidation: aws.sdk.kotlin.services.sagemaker.model.SkipModelValidation? = builder.skipModelValidation
    /**
     * Details about the algorithm that was used to create the model package.
     */
    public val sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = builder.sourceAlgorithmSpecification
    /**
     * A list of key value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     *
     * If you supply `ModelPackageGroupName`, your model package belongs to the model group you specify and uses the tags associated with the model group. In this case, you cannot supply a `tag` argument.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification. The following tasks are supported by Inference Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` | `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` | `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
     *
     * Specify "OTHER" if none of the tasks listed fit your use case.
     */
    public val task: kotlin.String? = builder.task
    /**
     * Specifies configurations for one or more transform jobs that SageMaker runs to test the model package.
     */
    public val validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = builder.validationSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelPackageRequest(")
        append("additionalInferenceSpecifications=$additionalInferenceSpecifications,")
        append("certifyForMarketplace=$certifyForMarketplace,")
        append("clientToken=$clientToken,")
        append("customerMetadataProperties=$customerMetadataProperties,")
        append("domain=$domain,")
        append("driftCheckBaselines=$driftCheckBaselines,")
        append("inferenceSpecification=$inferenceSpecification,")
        append("metadataProperties=$metadataProperties,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelMetrics=$modelMetrics,")
        append("modelPackageDescription=$modelPackageDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageName=$modelPackageName,")
        append("samplePayloadUrl=$samplePayloadUrl,")
        append("skipModelValidation=$skipModelValidation,")
        append("sourceAlgorithmSpecification=$sourceAlgorithmSpecification,")
        append("tags=$tags,")
        append("task=$task,")
        append("validationSpecification=$validationSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInferenceSpecifications?.hashCode() ?: 0
        result = 31 * result + (certifyForMarketplace?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customerMetadataProperties?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (driftCheckBaselines?.hashCode() ?: 0)
        result = 31 * result + (inferenceSpecification?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelMetrics?.hashCode() ?: 0)
        result = 31 * result + (modelPackageDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (samplePayloadUrl?.hashCode() ?: 0)
        result = 31 * result + (skipModelValidation?.hashCode() ?: 0)
        result = 31 * result + (sourceAlgorithmSpecification?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (validationSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelPackageRequest

        if (additionalInferenceSpecifications != other.additionalInferenceSpecifications) return false
        if (certifyForMarketplace != other.certifyForMarketplace) return false
        if (clientToken != other.clientToken) return false
        if (customerMetadataProperties != other.customerMetadataProperties) return false
        if (domain != other.domain) return false
        if (driftCheckBaselines != other.driftCheckBaselines) return false
        if (inferenceSpecification != other.inferenceSpecification) return false
        if (metadataProperties != other.metadataProperties) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelMetrics != other.modelMetrics) return false
        if (modelPackageDescription != other.modelPackageDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageName != other.modelPackageName) return false
        if (samplePayloadUrl != other.samplePayloadUrl) return false
        if (skipModelValidation != other.skipModelValidation) return false
        if (sourceAlgorithmSpecification != other.sourceAlgorithmSpecification) return false
        if (tags != other.tags) return false
        if (task != other.task) return false
        if (validationSpecification != other.validationSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         */
        public var additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = null
        /**
         * Whether to certify the model package for listing on Amazon Web Services Marketplace.
         *
         * This parameter is optional for unversioned models, and does not apply to versioned models.
         */
        public var certifyForMarketplace: kotlin.Boolean? = null
        /**
         * A unique token that guarantees that the call to this API is idempotent.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The metadata properties associated with the model package versions.
         */
        public var customerMetadataProperties: Map<String, String>? = null
        /**
         * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
         */
        public var domain: kotlin.String? = null
        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on [Drift Detection against Previous Baselines in SageMaker Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection) in the *Amazon SageMaker Developer Guide*.
         */
        public var driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = null
        /**
         * Specifies details about inference jobs that can be run with models based on this model package, including the following:
         * + The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * + The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
         * + The input and output content formats that the model package supports for inference.
         */
        public var inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        public var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * Whether the model is approved for deployment.
         *
         * This parameter is optional for versioned models, and does not apply to unversioned models.
         *
         * For versioned models, the value of this parameter must be set to `Approved` to deploy the model.
         */
        public var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * A structure that contains model metrics reports.
         */
        public var modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = null
        /**
         * A description of the model package.
         */
        public var modelPackageDescription: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.
         *
         * This parameter is required for versioned models, and does not apply to unversioned models.
         */
        public var modelPackageGroupName: kotlin.String? = null
        /**
         * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
         *
         * This parameter is required for unversioned models. It is not applicable to versioned models.
         */
        public var modelPackageName: kotlin.String? = null
        /**
         * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). This archive can hold multiple files that are all equally used in the load test. Each file in the archive must satisfy the size constraints of the [InvokeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html#API_runtime_InvokeEndpoint_RequestSyntax) call.
         */
        public var samplePayloadUrl: kotlin.String? = null
        /**
         * Indicates if you want to skip model validation.
         */
        public var skipModelValidation: aws.sdk.kotlin.services.sagemaker.model.SkipModelValidation? = null
        /**
         * Details about the algorithm that was used to create the model package.
         */
        public var sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = null
        /**
         * A list of key value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         *
         * If you supply `ModelPackageGroupName`, your model package belongs to the model group you specify and uses the tags associated with the model group. In this case, you cannot supply a `tag` argument.
         */
        public var tags: List<Tag>? = null
        /**
         * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification. The following tasks are supported by Inference Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` | `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` | `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
         *
         * Specify "OTHER" if none of the tasks listed fit your use case.
         */
        public var task: kotlin.String? = null
        /**
         * Specifies configurations for one or more transform jobs that SageMaker runs to test the model package.
         */
        public var validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest) : this() {
            this.additionalInferenceSpecifications = x.additionalInferenceSpecifications
            this.certifyForMarketplace = x.certifyForMarketplace
            this.clientToken = x.clientToken
            this.customerMetadataProperties = x.customerMetadataProperties
            this.domain = x.domain
            this.driftCheckBaselines = x.driftCheckBaselines
            this.inferenceSpecification = x.inferenceSpecification
            this.metadataProperties = x.metadataProperties
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelMetrics = x.modelMetrics
            this.modelPackageDescription = x.modelPackageDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageName = x.modelPackageName
            this.samplePayloadUrl = x.samplePayloadUrl
            this.skipModelValidation = x.skipModelValidation
            this.sourceAlgorithmSpecification = x.sourceAlgorithmSpecification
            this.tags = x.tags
            this.task = x.task
            this.validationSpecification = x.validationSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = CreateModelPackageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines] inside the given [block]
         */
        public fun driftCheckBaselines(block: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.Builder.() -> kotlin.Unit) {
            this.driftCheckBaselines = aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification] inside the given [block]
         */
        public fun inferenceSpecification(block: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.Builder.() -> kotlin.Unit) {
            this.inferenceSpecification = aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        public fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelMetrics] inside the given [block]
         */
        public fun modelMetrics(block: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.Builder.() -> kotlin.Unit) {
            this.modelMetrics = aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification] inside the given [block]
         */
        public fun sourceAlgorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.sourceAlgorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification] inside the given [block]
         */
        public fun validationSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.Builder.() -> kotlin.Unit) {
            this.validationSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
