// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateModelBiasJobDefinitionRequest private constructor(builder: Builder) {
    /**
     * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
     */
    public val jobDefinitionName: kotlin.String? = builder.jobDefinitionName
    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    public val jobResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = builder.jobResources
    /**
     * Configures the model bias job to run a specified Docker container image.
     */
    public val modelBiasAppSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification? = builder.modelBiasAppSpecification
    /**
     * The baseline configuration for a model bias job.
     */
    public val modelBiasBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig? = builder.modelBiasBaselineConfig
    /**
     * Inputs for the model bias job.
     */
    public val modelBiasJobInput: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput? = builder.modelBiasJobInput
    /**
     * The output configuration for monitoring jobs.
     */
    public val modelBiasJobOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = builder.modelBiasJobOutputConfig
    /**
     * Networking options for a model bias job.
     */
    public val networkConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig? = builder.networkConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = builder.stoppingCondition
    /**
     * (Optional) An array of key-value pairs. For more information, see [ Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelBiasJobDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelBiasJobDefinitionRequest(")
        append("jobDefinitionName=$jobDefinitionName,")
        append("jobResources=$jobResources,")
        append("modelBiasAppSpecification=$modelBiasAppSpecification,")
        append("modelBiasBaselineConfig=$modelBiasBaselineConfig,")
        append("modelBiasJobInput=$modelBiasJobInput,")
        append("modelBiasJobOutputConfig=$modelBiasJobOutputConfig,")
        append("networkConfig=$networkConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobDefinitionName?.hashCode() ?: 0
        result = 31 * result + (jobResources?.hashCode() ?: 0)
        result = 31 * result + (modelBiasAppSpecification?.hashCode() ?: 0)
        result = 31 * result + (modelBiasBaselineConfig?.hashCode() ?: 0)
        result = 31 * result + (modelBiasJobInput?.hashCode() ?: 0)
        result = 31 * result + (modelBiasJobOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelBiasJobDefinitionRequest

        if (jobDefinitionName != other.jobDefinitionName) return false
        if (jobResources != other.jobResources) return false
        if (modelBiasAppSpecification != other.modelBiasAppSpecification) return false
        if (modelBiasBaselineConfig != other.modelBiasBaselineConfig) return false
        if (modelBiasJobInput != other.modelBiasJobInput) return false
        if (modelBiasJobOutputConfig != other.modelBiasJobOutputConfig) return false
        if (networkConfig != other.networkConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelBiasJobDefinitionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
         */
        public var jobDefinitionName: kotlin.String? = null
        /**
         * Identifies the resources to deploy for a monitoring job.
         */
        public var jobResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = null
        /**
         * Configures the model bias job to run a specified Docker container image.
         */
        public var modelBiasAppSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification? = null
        /**
         * The baseline configuration for a model bias job.
         */
        public var modelBiasBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig? = null
        /**
         * Inputs for the model bias job.
         */
        public var modelBiasJobInput: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput? = null
        /**
         * The output configuration for monitoring jobs.
         */
        public var modelBiasJobOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = null
        /**
         * Networking options for a model bias job.
         */
        public var networkConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = null
        /**
         * (Optional) An array of key-value pairs. For more information, see [ Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL) in the *Amazon Web Services Billing and Cost Management User Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelBiasJobDefinitionRequest) : this() {
            this.jobDefinitionName = x.jobDefinitionName
            this.jobResources = x.jobResources
            this.modelBiasAppSpecification = x.modelBiasAppSpecification
            this.modelBiasBaselineConfig = x.modelBiasBaselineConfig
            this.modelBiasJobInput = x.modelBiasJobInput
            this.modelBiasJobOutputConfig = x.modelBiasJobOutputConfig
            this.networkConfig = x.networkConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelBiasJobDefinitionRequest = CreateModelBiasJobDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringResources] inside the given [block]
         */
        public fun jobResources(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.Builder.() -> kotlin.Unit) {
            this.jobResources = aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification] inside the given [block]
         */
        public fun modelBiasAppSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification.Builder.() -> kotlin.Unit) {
            this.modelBiasAppSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig] inside the given [block]
         */
        public fun modelBiasBaselineConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig.Builder.() -> kotlin.Unit) {
            this.modelBiasBaselineConfig = aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput] inside the given [block]
         */
        public fun modelBiasJobInput(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput.Builder.() -> kotlin.Unit) {
            this.modelBiasJobInput = aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig] inside the given [block]
         */
        public fun modelBiasJobOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.Builder.() -> kotlin.Unit) {
            this.modelBiasJobOutputConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig] inside the given [block]
         */
        public fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
