// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateDeviceFleetRequest private constructor(builder: Builder) {
    /**
     * A description of the fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the fleet that the device belongs to.
     */
    public val deviceFleetName: kotlin.String? = builder.deviceFleetName
    /**
     * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     *
     * For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".
     */
    public val enableIotRoleAlias: kotlin.Boolean? = builder.enableIotRoleAlias
    /**
     * The output configuration for storing sample data collected by the fleet.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Creates tags for the specified fleet.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateDeviceFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeviceFleetRequest(")
        append("description=$description,")
        append("deviceFleetName=$deviceFleetName,")
        append("enableIotRoleAlias=$enableIotRoleAlias,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (deviceFleetName?.hashCode() ?: 0)
        result = 31 * result + (enableIotRoleAlias?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeviceFleetRequest

        if (description != other.description) return false
        if (deviceFleetName != other.deviceFleetName) return false
        if (enableIotRoleAlias != other.enableIotRoleAlias) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateDeviceFleetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the fleet.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the fleet that the device belongs to.
         */
        public var deviceFleetName: kotlin.String? = null
        /**
         * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
         *
         * For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".
         */
        public var enableIotRoleAlias: kotlin.Boolean? = null
        /**
         * The output configuration for storing sample data collected by the fleet.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
         */
        public var roleArn: kotlin.String? = null
        /**
         * Creates tags for the specified fleet.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateDeviceFleetRequest) : this() {
            this.description = x.description
            this.deviceFleetName = x.deviceFleetName
            this.enableIotRoleAlias = x.enableIotRoleAlias
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateDeviceFleetRequest = CreateDeviceFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
