// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of a model compilation job.
 */
public class CompilationJobSummary private constructor(builder: Builder) {
    /**
     * The time when the model compilation job completed.
     */
    public val compilationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.compilationEndTime
    /**
     * The Amazon Resource Name (ARN) of the model compilation job.
     */
    public val compilationJobArn: kotlin.String? = builder.compilationJobArn
    /**
     * The name of the model compilation job that you want a summary for.
     */
    public val compilationJobName: kotlin.String? = builder.compilationJobName
    /**
     * The status of the model compilation job.
     */
    public val compilationJobStatus: aws.sdk.kotlin.services.sagemaker.model.CompilationJobStatus? = builder.compilationJobStatus
    /**
     * The time when the model compilation job started.
     */
    public val compilationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.compilationStartTime
    /**
     * The type of device that the model will run on after the compilation job has completed.
     */
    public val compilationTargetDevice: aws.sdk.kotlin.services.sagemaker.model.TargetDevice? = builder.compilationTargetDevice
    /**
     * The type of accelerator that the model will run on after the compilation job has completed.
     */
    public val compilationTargetPlatformAccelerator: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformAccelerator? = builder.compilationTargetPlatformAccelerator
    /**
     * The type of architecture that the model will run on after the compilation job has completed.
     */
    public val compilationTargetPlatformArch: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformArch? = builder.compilationTargetPlatformArch
    /**
     * The type of OS that the model will run on after the compilation job has completed.
     */
    public val compilationTargetPlatformOs: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformOs? = builder.compilationTargetPlatformOs
    /**
     * The time when the model compilation job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time when the model compilation job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CompilationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompilationJobSummary(")
        append("compilationEndTime=$compilationEndTime,")
        append("compilationJobArn=$compilationJobArn,")
        append("compilationJobName=$compilationJobName,")
        append("compilationJobStatus=$compilationJobStatus,")
        append("compilationStartTime=$compilationStartTime,")
        append("compilationTargetDevice=$compilationTargetDevice,")
        append("compilationTargetPlatformAccelerator=$compilationTargetPlatformAccelerator,")
        append("compilationTargetPlatformArch=$compilationTargetPlatformArch,")
        append("compilationTargetPlatformOs=$compilationTargetPlatformOs,")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compilationEndTime?.hashCode() ?: 0
        result = 31 * result + (compilationJobArn?.hashCode() ?: 0)
        result = 31 * result + (compilationJobName?.hashCode() ?: 0)
        result = 31 * result + (compilationJobStatus?.hashCode() ?: 0)
        result = 31 * result + (compilationStartTime?.hashCode() ?: 0)
        result = 31 * result + (compilationTargetDevice?.hashCode() ?: 0)
        result = 31 * result + (compilationTargetPlatformAccelerator?.hashCode() ?: 0)
        result = 31 * result + (compilationTargetPlatformArch?.hashCode() ?: 0)
        result = 31 * result + (compilationTargetPlatformOs?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompilationJobSummary

        if (compilationEndTime != other.compilationEndTime) return false
        if (compilationJobArn != other.compilationJobArn) return false
        if (compilationJobName != other.compilationJobName) return false
        if (compilationJobStatus != other.compilationJobStatus) return false
        if (compilationStartTime != other.compilationStartTime) return false
        if (compilationTargetDevice != other.compilationTargetDevice) return false
        if (compilationTargetPlatformAccelerator != other.compilationTargetPlatformAccelerator) return false
        if (compilationTargetPlatformArch != other.compilationTargetPlatformArch) return false
        if (compilationTargetPlatformOs != other.compilationTargetPlatformOs) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CompilationJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the model compilation job completed.
         */
        public var compilationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model compilation job.
         */
        public var compilationJobArn: kotlin.String? = null
        /**
         * The name of the model compilation job that you want a summary for.
         */
        public var compilationJobName: kotlin.String? = null
        /**
         * The status of the model compilation job.
         */
        public var compilationJobStatus: aws.sdk.kotlin.services.sagemaker.model.CompilationJobStatus? = null
        /**
         * The time when the model compilation job started.
         */
        public var compilationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of device that the model will run on after the compilation job has completed.
         */
        public var compilationTargetDevice: aws.sdk.kotlin.services.sagemaker.model.TargetDevice? = null
        /**
         * The type of accelerator that the model will run on after the compilation job has completed.
         */
        public var compilationTargetPlatformAccelerator: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformAccelerator? = null
        /**
         * The type of architecture that the model will run on after the compilation job has completed.
         */
        public var compilationTargetPlatformArch: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformArch? = null
        /**
         * The type of OS that the model will run on after the compilation job has completed.
         */
        public var compilationTargetPlatformOs: aws.sdk.kotlin.services.sagemaker.model.TargetPlatformOs? = null
        /**
         * The time when the model compilation job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the model compilation job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CompilationJobSummary) : this() {
            this.compilationEndTime = x.compilationEndTime
            this.compilationJobArn = x.compilationJobArn
            this.compilationJobName = x.compilationJobName
            this.compilationJobStatus = x.compilationJobStatus
            this.compilationStartTime = x.compilationStartTime
            this.compilationTargetDevice = x.compilationTargetDevice
            this.compilationTargetPlatformAccelerator = x.compilationTargetPlatformAccelerator
            this.compilationTargetPlatformArch = x.compilationTargetPlatformArch
            this.compilationTargetPlatformOs = x.compilationTargetPlatformOs
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CompilationJobSummary = CompilationJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
