// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration information for the Amazon SageMaker Debugger output tensor collections.
 */
public class CollectionConfiguration private constructor(builder: Builder) {
    /**
     * The name of the tensor collection. The name must be unique relative to other rule configuration names.
     */
    public val collectionName: kotlin.String? = builder.collectionName
    /**
     * Parameter values for the tensor collection. The allowed parameters are `"name"`, `"include_regex"`, `"reduction_config"`, `"save_config"`, `"tensor_names"`, and `"save_histogram"`.
     */
    public val collectionParameters: Map<String, String>? = builder.collectionParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CollectionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CollectionConfiguration(")
        append("collectionName=$collectionName,")
        append("collectionParameters=$collectionParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName?.hashCode() ?: 0
        result = 31 * result + (collectionParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CollectionConfiguration

        if (collectionName != other.collectionName) return false
        if (collectionParameters != other.collectionParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CollectionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the tensor collection. The name must be unique relative to other rule configuration names.
         */
        public var collectionName: kotlin.String? = null
        /**
         * Parameter values for the tensor collection. The allowed parameters are `"name"`, `"include_regex"`, `"reduction_config"`, `"save_config"`, `"tensor_names"`, and `"save_histogram"`.
         */
        public var collectionParameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CollectionConfiguration) : this() {
            this.collectionName = x.collectionName
            this.collectionParameters = x.collectionParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CollectionConfiguration = CollectionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
