// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The inference configuration parameter for the model container.
 */
public class ClarifyInferenceConfig private constructor(builder: Builder) {
    /**
     * A template string used to format a JSON record into an acceptable model container input. For example, a `ContentTemplate` string `'{"myfeatures":$features}'` will format a list of features `[1,2,3]` into the record string `'{"myfeatures":[1,2,3]}'`. Required only when the model container input is in JSON Lines format.
     */
    public val contentTemplate: kotlin.String? = builder.contentTemplate
    /**
     * The names of the features. If provided, these are included in the endpoint response payload to help readability of the `InvokeEndpoint` output. See the [Response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information.
     */
    public val featureHeaders: List<String>? = builder.featureHeaders
    /**
     * A list of data types of the features (optional). Applicable only to NLP explainability. If provided, `FeatureTypes` must have at least one `'text'` string (for example, `['text']`). If `FeatureTypes` is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the [response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information.
     */
    public val featureTypes: List<ClarifyFeatureType>? = builder.featureTypes
    /**
     * Provides the JMESPath expression to extract the features from a model container input in JSON Lines format. For example, if `FeaturesAttribute` is the JMESPath expression `'myfeatures'`, it extracts a list of features `[1,2,3]` from request data `'{"myfeatures":[1,2,3]}'`.
     */
    public val featuresAttribute: kotlin.String? = builder.featuresAttribute
    /**
     * A JMESPath expression used to locate the list of label headers in the model container output.
     *
     * **Example**: If the model container output of a batch request is `'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'`, then set `LabelAttribute` to `'labels'` to extract the list of label headers `["cat","dog","fish"]`
     */
    public val labelAttribute: kotlin.String? = builder.labelAttribute
    /**
     * For multiclass classification problems, the label headers are the names of the classes. Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the `InvokeEndpoint` API. See the [response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.
     */
    public val labelHeaders: List<String>? = builder.labelHeaders
    /**
     * A zero-based index used to extract a label header or list of label headers from model container output in CSV format.
     *
     * **Example for a multiclass model:** If the model container output consists of label headers followed by probabilities: `'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'`, set `LabelIndex` to `0` to select the label headers `['cat','dog','fish']`.
     */
    public val labelIndex: kotlin.Int? = builder.labelIndex
    /**
     * The maximum payload size (MB) allowed of a request from the explainer to the model container. Defaults to `6` MB.
     */
    public val maxPayloadInMb: kotlin.Int? = builder.maxPayloadInMb
    /**
     * The maximum number of records in a request that the model container can process when querying the model container for the predictions of a [synthetic dataset](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic). A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If `MaxRecordCount` is `1`, the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.
     */
    public val maxRecordCount: kotlin.Int? = builder.maxRecordCount
    /**
     * A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.
     *
     * **Example**: If the model container output of a single request is `'{"predicted_label":1,"probability":0.6}'`, then set `ProbabilityAttribute` to `'probability'`.
     */
    public val probabilityAttribute: kotlin.String? = builder.probabilityAttribute
    /**
     * A zero-based index used to extract a probability value (score) or list from model container output in CSV format. If this value is not provided, the entire model container output will be treated as a probability value (score) or list.
     *
     * **Example for a single class model:** If the model container output consists of a string-formatted prediction label followed by its probability: `'1,0.6'`, set `ProbabilityIndex` to `1` to select the probability value `0.6`.
     *
     * **Example for a multiclass model:** If the model container output consists of a string-formatted prediction label followed by its probability: `'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'`, set `ProbabilityIndex` to `1` to select the probability values `[0.1,0.6,0.3]`.
     */
    public val probabilityIndex: kotlin.Int? = builder.probabilityIndex

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClarifyInferenceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClarifyInferenceConfig(")
        append("contentTemplate=$contentTemplate,")
        append("featureHeaders=$featureHeaders,")
        append("featureTypes=$featureTypes,")
        append("featuresAttribute=$featuresAttribute,")
        append("labelAttribute=$labelAttribute,")
        append("labelHeaders=$labelHeaders,")
        append("labelIndex=$labelIndex,")
        append("maxPayloadInMb=$maxPayloadInMb,")
        append("maxRecordCount=$maxRecordCount,")
        append("probabilityAttribute=$probabilityAttribute,")
        append("probabilityIndex=$probabilityIndex")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentTemplate?.hashCode() ?: 0
        result = 31 * result + (featureHeaders?.hashCode() ?: 0)
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        result = 31 * result + (featuresAttribute?.hashCode() ?: 0)
        result = 31 * result + (labelAttribute?.hashCode() ?: 0)
        result = 31 * result + (labelHeaders?.hashCode() ?: 0)
        result = 31 * result + (labelIndex ?: 0)
        result = 31 * result + (maxPayloadInMb ?: 0)
        result = 31 * result + (maxRecordCount ?: 0)
        result = 31 * result + (probabilityAttribute?.hashCode() ?: 0)
        result = 31 * result + (probabilityIndex ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClarifyInferenceConfig

        if (contentTemplate != other.contentTemplate) return false
        if (featureHeaders != other.featureHeaders) return false
        if (featureTypes != other.featureTypes) return false
        if (featuresAttribute != other.featuresAttribute) return false
        if (labelAttribute != other.labelAttribute) return false
        if (labelHeaders != other.labelHeaders) return false
        if (labelIndex != other.labelIndex) return false
        if (maxPayloadInMb != other.maxPayloadInMb) return false
        if (maxRecordCount != other.maxRecordCount) return false
        if (probabilityAttribute != other.probabilityAttribute) return false
        if (probabilityIndex != other.probabilityIndex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClarifyInferenceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A template string used to format a JSON record into an acceptable model container input. For example, a `ContentTemplate` string `'{"myfeatures":$features}'` will format a list of features `[1,2,3]` into the record string `'{"myfeatures":[1,2,3]}'`. Required only when the model container input is in JSON Lines format.
         */
        public var contentTemplate: kotlin.String? = null
        /**
         * The names of the features. If provided, these are included in the endpoint response payload to help readability of the `InvokeEndpoint` output. See the [Response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information.
         */
        public var featureHeaders: List<String>? = null
        /**
         * A list of data types of the features (optional). Applicable only to NLP explainability. If provided, `FeatureTypes` must have at least one `'text'` string (for example, `['text']`). If `FeatureTypes` is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the [response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information.
         */
        public var featureTypes: List<ClarifyFeatureType>? = null
        /**
         * Provides the JMESPath expression to extract the features from a model container input in JSON Lines format. For example, if `FeaturesAttribute` is the JMESPath expression `'myfeatures'`, it extracts a list of features `[1,2,3]` from request data `'{"myfeatures":[1,2,3]}'`.
         */
        public var featuresAttribute: kotlin.String? = null
        /**
         * A JMESPath expression used to locate the list of label headers in the model container output.
         *
         * **Example**: If the model container output of a batch request is `'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'`, then set `LabelAttribute` to `'labels'` to extract the list of label headers `["cat","dog","fish"]`
         */
        public var labelAttribute: kotlin.String? = null
        /**
         * For multiclass classification problems, the label headers are the names of the classes. Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the `InvokeEndpoint` API. See the [response](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response) section under **Invoke the endpoint** in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.
         */
        public var labelHeaders: List<String>? = null
        /**
         * A zero-based index used to extract a label header or list of label headers from model container output in CSV format.
         *
         * **Example for a multiclass model:** If the model container output consists of label headers followed by probabilities: `'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'`, set `LabelIndex` to `0` to select the label headers `['cat','dog','fish']`.
         */
        public var labelIndex: kotlin.Int? = null
        /**
         * The maximum payload size (MB) allowed of a request from the explainer to the model container. Defaults to `6` MB.
         */
        public var maxPayloadInMb: kotlin.Int? = null
        /**
         * The maximum number of records in a request that the model container can process when querying the model container for the predictions of a [synthetic dataset](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic). A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If `MaxRecordCount` is `1`, the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.
         */
        public var maxRecordCount: kotlin.Int? = null
        /**
         * A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.
         *
         * **Example**: If the model container output of a single request is `'{"predicted_label":1,"probability":0.6}'`, then set `ProbabilityAttribute` to `'probability'`.
         */
        public var probabilityAttribute: kotlin.String? = null
        /**
         * A zero-based index used to extract a probability value (score) or list from model container output in CSV format. If this value is not provided, the entire model container output will be treated as a probability value (score) or list.
         *
         * **Example for a single class model:** If the model container output consists of a string-formatted prediction label followed by its probability: `'1,0.6'`, set `ProbabilityIndex` to `1` to select the probability value `0.6`.
         *
         * **Example for a multiclass model:** If the model container output consists of a string-formatted prediction label followed by its probability: `'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'`, set `ProbabilityIndex` to `1` to select the probability values `[0.1,0.6,0.3]`.
         */
        public var probabilityIndex: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClarifyInferenceConfig) : this() {
            this.contentTemplate = x.contentTemplate
            this.featureHeaders = x.featureHeaders
            this.featureTypes = x.featureTypes
            this.featuresAttribute = x.featuresAttribute
            this.labelAttribute = x.labelAttribute
            this.labelHeaders = x.labelHeaders
            this.labelIndex = x.labelIndex
            this.maxPayloadInMb = x.maxPayloadInMb
            this.maxRecordCount = x.maxRecordCount
            this.probabilityAttribute = x.probabilityAttribute
            this.probabilityIndex = x.probabilityIndex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClarifyInferenceConfig = ClarifyInferenceConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
