// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines a named input source, called a channel, to be used by an algorithm.
 */
public class ChannelSpecification private constructor(builder: Builder) {
    /**
     * A brief description of the channel.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether the channel is required by the algorithm.
     */
    public val isRequired: kotlin.Boolean? = builder.isRequired
    /**
     * The name of the channel.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The allowed compression types, if data compression is used.
     */
    public val supportedCompressionTypes: List<CompressionType>? = builder.supportedCompressionTypes
    /**
     * The supported MIME types for the data.
     */
    public val supportedContentTypes: List<String>? = builder.supportedContentTypes
    /**
     * The allowed input mode, either FILE or PIPE.
     *
     * In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.
     *
     * In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     */
    public val supportedInputModes: List<TrainingInputMode>? = builder.supportedInputModes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSpecification(")
        append("description=$description,")
        append("isRequired=$isRequired,")
        append("name=$name,")
        append("supportedCompressionTypes=$supportedCompressionTypes,")
        append("supportedContentTypes=$supportedContentTypes,")
        append("supportedInputModes=$supportedInputModes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (isRequired?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (supportedCompressionTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedContentTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedInputModes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelSpecification

        if (description != other.description) return false
        if (isRequired != other.isRequired) return false
        if (name != other.name) return false
        if (supportedCompressionTypes != other.supportedCompressionTypes) return false
        if (supportedContentTypes != other.supportedContentTypes) return false
        if (supportedInputModes != other.supportedInputModes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A brief description of the channel.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether the channel is required by the algorithm.
         */
        public var isRequired: kotlin.Boolean? = null
        /**
         * The name of the channel.
         */
        public var name: kotlin.String? = null
        /**
         * The allowed compression types, if data compression is used.
         */
        public var supportedCompressionTypes: List<CompressionType>? = null
        /**
         * The supported MIME types for the data.
         */
        public var supportedContentTypes: List<String>? = null
        /**
         * The allowed input mode, either FILE or PIPE.
         *
         * In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.
         *
         * In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         */
        public var supportedInputModes: List<TrainingInputMode>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification) : this() {
            this.description = x.description
            this.isRequired = x.isRequired
            this.name = x.name
            this.supportedCompressionTypes = x.supportedCompressionTypes
            this.supportedContentTypes = x.supportedContentTypes
            this.supportedInputModes = x.supportedInputModes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ChannelSpecification = ChannelSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
