// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Stores the configuration information for how a candidate is generated (optional).
 */
public class AutoMlCandidateGenerationConfig private constructor(builder: Builder) {
    /**
     * Stores the configuration information for the selection of algorithms used to train the model candidates.
     *
     * The list of available algorithms to choose from depends on the training mode set in `AutoMLJobConfig.Mode`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html).
     * + `AlgorithmsConfig` should not be set in `AUTO` training mode.
     * + When `AlgorithmsConfig` is provided, one `AutoMLAlgorithms` attribute must be set and one only.If the list of algorithms provided as values for `AutoMLAlgorithms` is empty, `AutoMLCandidateGenerationConfig` uses the full set of algorithms for the given training mode.
     * + When `AlgorithmsConfig` is not provided, `AutoMLCandidateGenerationConfig` uses the full set of algorithms for the given training mode.
     *
     * For the list of all algorithms per training mode, see [ AutoMLAlgorithmConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html).
     *
     * For more information on each algorithm, see the [Algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) section in Autopilot developer guide.
     */
    public val algorithmsConfig: List<AutoMlAlgorithmConfig>? = builder.algorithmsConfig
    /**
     * A URL to the Amazon S3 data source containing selected features from the input data source to run an Autopilot job. You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
     *
     * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
     *
     * You can also specify the data type of the feature (optional) in the format shown below:
     *
     * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
     *
     * These column keys may not include the target column.
     *
     * In ensembling mode, Autopilot only supports the following data types: `numeric`, `categorical`, `text`, and `datetime`. In HPO mode, Autopilot can support `numeric`, `categorical`, `text`, `datetime`, and `sequence`.
     *
     * If only `FeatureDataTypes` is provided, the column keys (`col1`, `col2`,..) should be a subset of the column names in the input data.
     *
     * If both `FeatureDataTypes` and `FeatureAttributeNames` are provided, then the column keys should be a subset of the column names provided in `FeatureAttributeNames`.
     *
     * The key name `FeatureAttributeNames` is fixed. The values listed in `["col1", "col2", ...]` are case sensitive and should be a list of strings containing unique values that are a subset of the column names in the input data. The list of columns provided must not include the target column.
     */
    public val featureSpecificationS3Uri: kotlin.String? = builder.featureSpecificationS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlCandidateGenerationConfig(")
        append("algorithmsConfig=$algorithmsConfig,")
        append("featureSpecificationS3Uri=$featureSpecificationS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmsConfig?.hashCode() ?: 0
        result = 31 * result + (featureSpecificationS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlCandidateGenerationConfig

        if (algorithmsConfig != other.algorithmsConfig) return false
        if (featureSpecificationS3Uri != other.featureSpecificationS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Stores the configuration information for the selection of algorithms used to train the model candidates.
         *
         * The list of available algorithms to choose from depends on the training mode set in `AutoMLJobConfig.Mode`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html).
         * + `AlgorithmsConfig` should not be set in `AUTO` training mode.
         * + When `AlgorithmsConfig` is provided, one `AutoMLAlgorithms` attribute must be set and one only.If the list of algorithms provided as values for `AutoMLAlgorithms` is empty, `AutoMLCandidateGenerationConfig` uses the full set of algorithms for the given training mode.
         * + When `AlgorithmsConfig` is not provided, `AutoMLCandidateGenerationConfig` uses the full set of algorithms for the given training mode.
         *
         * For the list of all algorithms per training mode, see [ AutoMLAlgorithmConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html).
         *
         * For more information on each algorithm, see the [Algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support) section in Autopilot developer guide.
         */
        public var algorithmsConfig: List<AutoMlAlgorithmConfig>? = null
        /**
         * A URL to the Amazon S3 data source containing selected features from the input data source to run an Autopilot job. You can input `FeatureAttributeNames` (optional) in JSON format as shown below:
         *
         * `{ "FeatureAttributeNames":["col1", "col2", ...] }`.
         *
         * You can also specify the data type of the feature (optional) in the format shown below:
         *
         * `{ "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }`
         *
         * These column keys may not include the target column.
         *
         * In ensembling mode, Autopilot only supports the following data types: `numeric`, `categorical`, `text`, and `datetime`. In HPO mode, Autopilot can support `numeric`, `categorical`, `text`, `datetime`, and `sequence`.
         *
         * If only `FeatureDataTypes` is provided, the column keys (`col1`, `col2`,..) should be a subset of the column names in the input data.
         *
         * If both `FeatureDataTypes` and `FeatureAttributeNames` are provided, then the column keys should be a subset of the column names provided in `FeatureAttributeNames`.
         *
         * The key name `FeatureAttributeNames` is fixed. The values listed in `["col1", "col2", ...]` are case sensitive and should be a list of strings containing unique values that are a subset of the column names in the input data. The list of columns provided must not include the target column.
         */
        public var featureSpecificationS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig) : this() {
            this.algorithmsConfig = x.algorithmsConfig
            this.featureSpecificationS3Uri = x.featureSpecificationS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidateGenerationConfig = AutoMlCandidateGenerationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
