// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the configuration for asynchronous inference invocation outputs.
 */
public class AsyncInferenceOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the configuration for notifications of inference results for asynchronous inference.
     */
    public val notificationConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceNotificationConfig? = builder.notificationConfig
    /**
     * The Amazon S3 location to upload failure inference responses to.
     */
    public val s3FailurePath: kotlin.String? = builder.s3FailurePath
    /**
     * The Amazon S3 location to upload inference responses to.
     */
    public val s3OutputPath: kotlin.String? = builder.s3OutputPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AsyncInferenceOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("notificationConfig=$notificationConfig,")
        append("s3FailurePath=$s3FailurePath,")
        append("s3OutputPath=$s3OutputPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (s3FailurePath?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AsyncInferenceOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (notificationConfig != other.notificationConfig) return false
        if (s3FailurePath != other.s3FailurePath) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceOutputConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the configuration for notifications of inference results for asynchronous inference.
         */
        public var notificationConfig: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceNotificationConfig? = null
        /**
         * The Amazon S3 location to upload failure inference responses to.
         */
        public var s3FailurePath: kotlin.String? = null
        /**
         * The Amazon S3 location to upload inference responses to.
         */
        public var s3OutputPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.notificationConfig = x.notificationConfig
            this.s3FailurePath = x.s3FailurePath
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceOutputConfig = AsyncInferenceOutputConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceNotificationConfig] inside the given [block]
         */
        public fun notificationConfig(block: aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceNotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.sagemaker.model.AsyncInferenceNotificationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
