// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration for running a SageMaker image as a KernelGateway app.
 */
public class AppImageConfigDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AppImageConfig.
     */
    public val appImageConfigArn: kotlin.String? = builder.appImageConfigArn
    /**
     * The name of the AppImageConfig. Must be unique to your account.
     */
    public val appImageConfigName: kotlin.String? = builder.appImageConfigName
    /**
     * When the AppImageConfig was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The configuration for the file system and the runtime, such as the environment variables and entry point.
     */
    public val jupyterLabAppImageConfig: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig? = builder.jupyterLabAppImageConfig
    /**
     * The configuration for the file system and kernels in the SageMaker image.
     */
    public val kernelGatewayImageConfig: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig? = builder.kernelGatewayImageConfig
    /**
     * When the AppImageConfig was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AppImageConfigDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppImageConfigDetails(")
        append("appImageConfigArn=$appImageConfigArn,")
        append("appImageConfigName=$appImageConfigName,")
        append("creationTime=$creationTime,")
        append("jupyterLabAppImageConfig=$jupyterLabAppImageConfig,")
        append("kernelGatewayImageConfig=$kernelGatewayImageConfig,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appImageConfigArn?.hashCode() ?: 0
        result = 31 * result + (appImageConfigName?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (jupyterLabAppImageConfig?.hashCode() ?: 0)
        result = 31 * result + (kernelGatewayImageConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppImageConfigDetails

        if (appImageConfigArn != other.appImageConfigArn) return false
        if (appImageConfigName != other.appImageConfigName) return false
        if (creationTime != other.creationTime) return false
        if (jupyterLabAppImageConfig != other.jupyterLabAppImageConfig) return false
        if (kernelGatewayImageConfig != other.kernelGatewayImageConfig) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AppImageConfigDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AppImageConfig.
         */
        public var appImageConfigArn: kotlin.String? = null
        /**
         * The name of the AppImageConfig. Must be unique to your account.
         */
        public var appImageConfigName: kotlin.String? = null
        /**
         * When the AppImageConfig was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration for the file system and the runtime, such as the environment variables and entry point.
         */
        public var jupyterLabAppImageConfig: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig? = null
        /**
         * The configuration for the file system and kernels in the SageMaker image.
         */
        public var kernelGatewayImageConfig: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig? = null
        /**
         * When the AppImageConfig was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AppImageConfigDetails) : this() {
            this.appImageConfigArn = x.appImageConfigArn
            this.appImageConfigName = x.appImageConfigName
            this.creationTime = x.creationTime
            this.jupyterLabAppImageConfig = x.jupyterLabAppImageConfig
            this.kernelGatewayImageConfig = x.kernelGatewayImageConfig
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AppImageConfigDetails = AppImageConfigDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig] inside the given [block]
         */
        public fun jupyterLabAppImageConfig(block: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig.Builder.() -> kotlin.Unit) {
            this.jupyterLabAppImageConfig = aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppImageConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig] inside the given [block]
         */
        public fun kernelGatewayImageConfig(block: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig.Builder.() -> kotlin.Unit) {
            this.kernelGatewayImageConfig = aws.sdk.kotlin.services.sagemaker.model.KernelGatewayImageConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
