// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
import aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceLifecycleHook
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeNotebookInstanceLifecycleConfigOperationDeserializer: HttpDeserialize<DescribeNotebookInstanceLifecycleConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeNotebookInstanceLifecycleConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeNotebookInstanceLifecycleConfigError(context, call)
        }
        val builder = DescribeNotebookInstanceLifecycleConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNotebookInstanceLifecycleConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeNotebookInstanceLifecycleConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNotebookInstanceLifecycleConfigOperationBody(builder: DescribeNotebookInstanceLifecycleConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NOTEBOOKINSTANCELIFECYCLECONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceLifecycleConfigArn"))
    val NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceLifecycleConfigName"))
    val ONCREATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OnCreate"))
    val ONSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OnStart"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NOTEBOOKINSTANCELIFECYCLECONFIGARN_DESCRIPTOR)
        field(NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR)
        field(ONCREATE_DESCRIPTOR)
        field(ONSTART_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NOTEBOOKINSTANCELIFECYCLECONFIGARN_DESCRIPTOR.index -> builder.notebookInstanceLifecycleConfigArn = deserializeString()
                NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR.index -> builder.notebookInstanceLifecycleConfigName = deserializeString()
                ONCREATE_DESCRIPTOR.index -> builder.onCreate =
                    deserializer.deserializeList(ONCREATE_DESCRIPTOR) {
                        val col0 = mutableListOf<NotebookInstanceLifecycleHook>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNotebookInstanceLifecycleHookDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ONSTART_DESCRIPTOR.index -> builder.onStart =
                    deserializer.deserializeList(ONSTART_DESCRIPTOR) {
                        val col0 = mutableListOf<NotebookInstanceLifecycleHook>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNotebookInstanceLifecycleHookDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
