// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeMonitoringScheduleResponse
import aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary
import aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig
import aws.sdk.kotlin.services.sagemaker.model.MonitoringType
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeMonitoringScheduleOperationDeserializer: HttpDeserialize<DescribeMonitoringScheduleResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeMonitoringScheduleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMonitoringScheduleError(context, call)
        }
        val builder = DescribeMonitoringScheduleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeMonitoringScheduleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeMonitoringScheduleError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMonitoringScheduleOperationBody(builder: DescribeMonitoringScheduleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointName"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val LASTMONITORINGEXECUTIONSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastMonitoringExecutionSummary"))
    val MONITORINGSCHEDULEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitoringScheduleArn"))
    val MONITORINGSCHEDULECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MonitoringScheduleConfig"))
    val MONITORINGSCHEDULENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitoringScheduleName"))
    val MONITORINGSCHEDULESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MonitoringScheduleStatus"))
    val MONITORINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MonitoringType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDPOINTNAME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LASTMONITORINGEXECUTIONSUMMARY_DESCRIPTOR)
        field(MONITORINGSCHEDULEARN_DESCRIPTOR)
        field(MONITORINGSCHEDULECONFIG_DESCRIPTOR)
        field(MONITORINGSCHEDULENAME_DESCRIPTOR)
        field(MONITORINGSCHEDULESTATUS_DESCRIPTOR)
        field(MONITORINGTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENDPOINTNAME_DESCRIPTOR.index -> builder.endpointName = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMONITORINGEXECUTIONSUMMARY_DESCRIPTOR.index -> builder.lastMonitoringExecutionSummary = deserializeMonitoringExecutionSummaryDocument(deserializer)
                MONITORINGSCHEDULEARN_DESCRIPTOR.index -> builder.monitoringScheduleArn = deserializeString()
                MONITORINGSCHEDULECONFIG_DESCRIPTOR.index -> builder.monitoringScheduleConfig = deserializeMonitoringScheduleConfigDocument(deserializer)
                MONITORINGSCHEDULENAME_DESCRIPTOR.index -> builder.monitoringScheduleName = deserializeString()
                MONITORINGSCHEDULESTATUS_DESCRIPTOR.index -> builder.monitoringScheduleStatus = deserializeString().let { ScheduleStatus.fromValue(it) }
                MONITORINGTYPE_DESCRIPTOR.index -> builder.monitoringType = deserializeString().let { MonitoringType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
