// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeModelCardExportJobResponse
import aws.sdk.kotlin.services.sagemaker.model.ModelCardExportArtifacts
import aws.sdk.kotlin.services.sagemaker.model.ModelCardExportJobStatus
import aws.sdk.kotlin.services.sagemaker.model.ModelCardExportOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeModelCardExportJobOperationDeserializer: HttpDeserialize<DescribeModelCardExportJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeModelCardExportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeModelCardExportJobError(context, call)
        }
        val builder = DescribeModelCardExportJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeModelCardExportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeModelCardExportJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeModelCardExportJobOperationBody(builder: DescribeModelCardExportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val EXPORTARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExportArtifacts"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedAt"))
    val MODELCARDEXPORTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelCardExportJobArn"))
    val MODELCARDEXPORTJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelCardExportJobName"))
    val MODELCARDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelCardName"))
    val MODELCARDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ModelCardVersion"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(EXPORTARTIFACTS_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDAT_DESCRIPTOR)
        field(MODELCARDEXPORTJOBARN_DESCRIPTOR)
        field(MODELCARDEXPORTJOBNAME_DESCRIPTOR)
        field(MODELCARDNAME_DESCRIPTOR)
        field(MODELCARDVERSION_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                EXPORTARTIFACTS_DESCRIPTOR.index -> builder.exportArtifacts = deserializeModelCardExportArtifactsDocument(deserializer)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDAT_DESCRIPTOR.index -> builder.lastModifiedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELCARDEXPORTJOBARN_DESCRIPTOR.index -> builder.modelCardExportJobArn = deserializeString()
                MODELCARDEXPORTJOBNAME_DESCRIPTOR.index -> builder.modelCardExportJobName = deserializeString()
                MODELCARDNAME_DESCRIPTOR.index -> builder.modelCardName = deserializeString()
                MODELCARDVERSION_DESCRIPTOR.index -> builder.modelCardVersion = deserializeInt()
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeModelCardExportOutputConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ModelCardExportJobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
