// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationSpecification
import aws.sdk.kotlin.services.sagemaker.model.CreateAlgorithmRequest
import aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.sdk.kotlin.services.sagemaker.model.TrainingSpecification
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAlgorithmOperationSerializer: HttpSerialize<CreateAlgorithmRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAlgorithmRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateAlgorithmOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateAlgorithmOperationBody(context: ExecutionContext, input: CreateAlgorithmRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALGORITHMDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmDescription"))
    val ALGORITHMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AlgorithmName"))
    val CERTIFYFORMARKETPLACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("CertifyForMarketplace"))
    val INFERENCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InferenceSpecification"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TRAININGSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingSpecification"))
    val VALIDATIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMDESCRIPTION_DESCRIPTOR)
        field(ALGORITHMNAME_DESCRIPTOR)
        field(CERTIFYFORMARKETPLACE_DESCRIPTOR)
        field(INFERENCESPECIFICATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAININGSPECIFICATION_DESCRIPTOR)
        field(VALIDATIONSPECIFICATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.algorithmDescription?.let { field(ALGORITHMDESCRIPTION_DESCRIPTOR, it) }
        input.algorithmName?.let { field(ALGORITHMNAME_DESCRIPTOR, it) }
        input.certifyForMarketplace?.let { field(CERTIFYFORMARKETPLACE_DESCRIPTOR, it) }
        input.inferenceSpecification?.let { field(INFERENCESPECIFICATION_DESCRIPTOR, it, ::serializeInferenceSpecificationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.trainingSpecification?.let { field(TRAININGSPECIFICATION_DESCRIPTOR, it, ::serializeTrainingSpecificationDocument) }
        input.validationSpecification?.let { field(VALIDATIONSPECIFICATION_DESCRIPTOR, it, ::serializeAlgorithmValidationSpecificationDocument) }
    }
    return serializer.toByteArray()
}
