// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class UpdateImageVersionRequest private constructor(builder: Builder) {
    /**
     * The alias of the image version.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * A list of aliases to add.
     */
    public val aliasesToAdd: List<String>? = builder.aliasesToAdd
    /**
     * A list of aliases to delete.
     */
    public val aliasesToDelete: List<String>? = builder.aliasesToDelete
    /**
     * Indicates Horovod compatibility.
     */
    public val horovod: kotlin.Boolean? = builder.horovod
    /**
     * The name of the image.
     */
    public val imageName: kotlin.String? = builder.imageName
    /**
     * Indicates SageMaker job type compatibility.
     * + `TRAINING`: The image version is compatible with SageMaker training jobs.
     * + `INFERENCE`: The image version is compatible with SageMaker inference jobs.
     * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker notebook kernels.
     */
    public val jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = builder.jobType
    /**
     * The machine learning framework vended in the image version.
     */
    public val mlFramework: kotlin.String? = builder.mlFramework
    /**
     * Indicates CPU or GPU compatibility.
     * + `CPU`: The image version is compatible with CPU.
     * + `GPU`: The image version is compatible with GPU.
     */
    public val processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = builder.processor
    /**
     * The supported programming language and its version.
     */
    public val programmingLang: kotlin.String? = builder.programmingLang
    /**
     * The maintainer description of the image version.
     */
    public val releaseNotes: kotlin.String? = builder.releaseNotes
    /**
     * The availability of the image version specified by the maintainer.
     * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
     * + `STABLE`: The image version is stable.
     * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
     * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
     */
    public val vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = builder.vendorGuidance
    /**
     * The version of the image.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateImageVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateImageVersionRequest(")
        append("alias=$alias,")
        append("aliasesToAdd=$aliasesToAdd,")
        append("aliasesToDelete=$aliasesToDelete,")
        append("horovod=$horovod,")
        append("imageName=$imageName,")
        append("jobType=$jobType,")
        append("mlFramework=$mlFramework,")
        append("processor=$processor,")
        append("programmingLang=$programmingLang,")
        append("releaseNotes=$releaseNotes,")
        append("vendorGuidance=$vendorGuidance,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (aliasesToAdd?.hashCode() ?: 0)
        result = 31 * result + (aliasesToDelete?.hashCode() ?: 0)
        result = 31 * result + (horovod?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (mlFramework?.hashCode() ?: 0)
        result = 31 * result + (processor?.hashCode() ?: 0)
        result = 31 * result + (programmingLang?.hashCode() ?: 0)
        result = 31 * result + (releaseNotes?.hashCode() ?: 0)
        result = 31 * result + (vendorGuidance?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateImageVersionRequest

        if (alias != other.alias) return false
        if (aliasesToAdd != other.aliasesToAdd) return false
        if (aliasesToDelete != other.aliasesToDelete) return false
        if (horovod != other.horovod) return false
        if (imageName != other.imageName) return false
        if (jobType != other.jobType) return false
        if (mlFramework != other.mlFramework) return false
        if (processor != other.processor) return false
        if (programmingLang != other.programmingLang) return false
        if (releaseNotes != other.releaseNotes) return false
        if (vendorGuidance != other.vendorGuidance) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateImageVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The alias of the image version.
         */
        public var alias: kotlin.String? = null
        /**
         * A list of aliases to add.
         */
        public var aliasesToAdd: List<String>? = null
        /**
         * A list of aliases to delete.
         */
        public var aliasesToDelete: List<String>? = null
        /**
         * Indicates Horovod compatibility.
         */
        public var horovod: kotlin.Boolean? = null
        /**
         * The name of the image.
         */
        public var imageName: kotlin.String? = null
        /**
         * Indicates SageMaker job type compatibility.
         * + `TRAINING`: The image version is compatible with SageMaker training jobs.
         * + `INFERENCE`: The image version is compatible with SageMaker inference jobs.
         * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker notebook kernels.
         */
        public var jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = null
        /**
         * The machine learning framework vended in the image version.
         */
        public var mlFramework: kotlin.String? = null
        /**
         * Indicates CPU or GPU compatibility.
         * + `CPU`: The image version is compatible with CPU.
         * + `GPU`: The image version is compatible with GPU.
         */
        public var processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = null
        /**
         * The supported programming language and its version.
         */
        public var programmingLang: kotlin.String? = null
        /**
         * The maintainer description of the image version.
         */
        public var releaseNotes: kotlin.String? = null
        /**
         * The availability of the image version specified by the maintainer.
         * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
         * + `STABLE`: The image version is stable.
         * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
         * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
         */
        public var vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = null
        /**
         * The version of the image.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateImageVersionRequest) : this() {
            this.alias = x.alias
            this.aliasesToAdd = x.aliasesToAdd
            this.aliasesToDelete = x.aliasesToDelete
            this.horovod = x.horovod
            this.imageName = x.imageName
            this.jobType = x.jobType
            this.mlFramework = x.mlFramework
            this.processor = x.processor
            this.programmingLang = x.programmingLang
            this.releaseNotes = x.releaseNotes
            this.vendorGuidance = x.vendorGuidance
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateImageVersionRequest = UpdateImageVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
