// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class UpdateEndpointRequest private constructor(builder: Builder) {
    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    public val deploymentConfig: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig? = builder.deploymentConfig
    /**
     * The name of the new endpoint configuration.
     */
    public val endpointConfigName: kotlin.String? = builder.endpointConfigName
    /**
     * The name of the endpoint whose configuration you want to update.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * When you are updating endpoint resources with `RetainAllVariantProperties`, whose value is set to `true`, `ExcludeRetainedVariantProperties` specifies the list of type [VariantProperty](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html) to override with the values provided by `EndpointConfig`. If you don't specify a value for `ExcludeRetainedVariantProperties`, no variant properties are overridden.
     */
    public val excludeRetainedVariantProperties: List<VariantProperty>? = builder.excludeRetainedVariantProperties
    /**
     * When updating endpoint resources, enables or disables the retention of [variant properties](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html), such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set `RetainAllVariantProperties` to `true`. To use the variant properties specified in a new `EndpointConfig` call when updating an endpoint, set `RetainAllVariantProperties` to `false`. The default is `false`.
     */
    public val retainAllVariantProperties: kotlin.Boolean? = builder.retainAllVariantProperties
    /**
     * Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
     */
    public val retainDeploymentConfig: kotlin.Boolean? = builder.retainDeploymentConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEndpointRequest(")
        append("deploymentConfig=$deploymentConfig,")
        append("endpointConfigName=$endpointConfigName,")
        append("endpointName=$endpointName,")
        append("excludeRetainedVariantProperties=$excludeRetainedVariantProperties,")
        append("retainAllVariantProperties=$retainAllVariantProperties,")
        append("retainDeploymentConfig=$retainDeploymentConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentConfig?.hashCode() ?: 0
        result = 31 * result + (endpointConfigName?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (excludeRetainedVariantProperties?.hashCode() ?: 0)
        result = 31 * result + (retainAllVariantProperties?.hashCode() ?: 0)
        result = 31 * result + (retainDeploymentConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEndpointRequest

        if (deploymentConfig != other.deploymentConfig) return false
        if (endpointConfigName != other.endpointConfigName) return false
        if (endpointName != other.endpointName) return false
        if (excludeRetainedVariantProperties != other.excludeRetainedVariantProperties) return false
        if (retainAllVariantProperties != other.retainAllVariantProperties) return false
        if (retainDeploymentConfig != other.retainDeploymentConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateEndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         */
        public var deploymentConfig: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig? = null
        /**
         * The name of the new endpoint configuration.
         */
        public var endpointConfigName: kotlin.String? = null
        /**
         * The name of the endpoint whose configuration you want to update.
         */
        public var endpointName: kotlin.String? = null
        /**
         * When you are updating endpoint resources with `RetainAllVariantProperties`, whose value is set to `true`, `ExcludeRetainedVariantProperties` specifies the list of type [VariantProperty](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html) to override with the values provided by `EndpointConfig`. If you don't specify a value for `ExcludeRetainedVariantProperties`, no variant properties are overridden.
         */
        public var excludeRetainedVariantProperties: List<VariantProperty>? = null
        /**
         * When updating endpoint resources, enables or disables the retention of [variant properties](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html), such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set `RetainAllVariantProperties` to `true`. To use the variant properties specified in a new `EndpointConfig` call when updating an endpoint, set `RetainAllVariantProperties` to `false`. The default is `false`.
         */
        public var retainAllVariantProperties: kotlin.Boolean? = null
        /**
         * Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
         */
        public var retainDeploymentConfig: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateEndpointRequest) : this() {
            this.deploymentConfig = x.deploymentConfig
            this.endpointConfigName = x.endpointConfigName
            this.endpointName = x.endpointName
            this.excludeRetainedVariantProperties = x.excludeRetainedVariantProperties
            this.retainAllVariantProperties = x.retainAllVariantProperties
            this.retainDeploymentConfig = x.retainDeploymentConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateEndpointRequest = UpdateEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig] inside the given [block]
         */
        public fun deploymentConfig(block: aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig.Builder.() -> kotlin.Unit) {
            this.deploymentConfig = aws.sdk.kotlin.services.sagemaker.model.DeploymentConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
