// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines the input needed to run a transform job using the inference specification specified in the algorithm.
 */
public class TransformJobDefinition private constructor(builder: Builder) {
    /**
     * A string that determines the number of records included in a single mini-batch.
     *
     * `SingleRecord` means only one record is used per mini-batch. `MultiRecord` means a mini-batch is set to contain as many records that can fit within the `MaxPayloadInMB` limit.
     */
    public val batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = builder.batchStrategy
    /**
     * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.
     */
    public val maxConcurrentTransforms: kotlin.Int? = builder.maxConcurrentTransforms
    /**
     * The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).
     */
    public val maxPayloadInMb: kotlin.Int? = builder.maxPayloadInMb
    /**
     * A description of the input source and the way the transform job consumes it.
     */
    public val transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = builder.transformInput
    /**
     * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     */
    public val transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = builder.transformOutput
    /**
     * Identifies the ML compute instances for the transform job.
     */
    public val transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = builder.transformResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransformJobDefinition(")
        append("batchStrategy=$batchStrategy,")
        append("environment=$environment,")
        append("maxConcurrentTransforms=$maxConcurrentTransforms,")
        append("maxPayloadInMb=$maxPayloadInMb,")
        append("transformInput=$transformInput,")
        append("transformOutput=$transformOutput,")
        append("transformResources=$transformResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchStrategy?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrentTransforms ?: 0)
        result = 31 * result + (maxPayloadInMb ?: 0)
        result = 31 * result + (transformInput?.hashCode() ?: 0)
        result = 31 * result + (transformOutput?.hashCode() ?: 0)
        result = 31 * result + (transformResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransformJobDefinition

        if (batchStrategy != other.batchStrategy) return false
        if (environment != other.environment) return false
        if (maxConcurrentTransforms != other.maxConcurrentTransforms) return false
        if (maxPayloadInMb != other.maxPayloadInMb) return false
        if (transformInput != other.transformInput) return false
        if (transformOutput != other.transformOutput) return false
        if (transformResources != other.transformResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string that determines the number of records included in a single mini-batch.
         *
         * `SingleRecord` means only one record is used per mini-batch. `MultiRecord` means a mini-batch is set to contain as many records that can fit within the `MaxPayloadInMB` limit.
         */
        public var batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = null
        /**
         * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
         */
        public var environment: Map<String, String>? = null
        /**
         * The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.
         */
        public var maxConcurrentTransforms: kotlin.Int? = null
        /**
         * The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).
         */
        public var maxPayloadInMb: kotlin.Int? = null
        /**
         * A description of the input source and the way the transform job consumes it.
         */
        public var transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = null
        /**
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
         */
        public var transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = null
        /**
         * Identifies the ML compute instances for the transform job.
         */
        public var transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition) : this() {
            this.batchStrategy = x.batchStrategy
            this.environment = x.environment
            this.maxConcurrentTransforms = x.maxConcurrentTransforms
            this.maxPayloadInMb = x.maxPayloadInMb
            this.transformInput = x.transformInput
            this.transformOutput = x.transformOutput
            this.transformResources = x.transformResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition = TransformJobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformInput] inside the given [block]
         */
        public fun transformInput(block: aws.sdk.kotlin.services.sagemaker.model.TransformInput.Builder.() -> kotlin.Unit) {
            this.transformInput = aws.sdk.kotlin.services.sagemaker.model.TransformInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformOutput] inside the given [block]
         */
        public fun transformOutput(block: aws.sdk.kotlin.services.sagemaker.model.TransformOutput.Builder.() -> kotlin.Unit) {
            this.transformOutput = aws.sdk.kotlin.services.sagemaker.model.TransformOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformResources] inside the given [block]
         */
        public fun transformResources(block: aws.sdk.kotlin.services.sagemaker.model.TransformResources.Builder.() -> kotlin.Unit) {
            this.transformResources = aws.sdk.kotlin.services.sagemaker.model.TransformResources.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
