// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the S3 data source.
 *
 * Your input bucket must be in the same Amazon Web Services region as your training job.
 */
public class S3DataSource private constructor(builder: Builder) {
    /**
     * A list of one or more attribute names to use that are found in a specified augmented manifest file.
     */
    public val attributeNames: List<String>? = builder.attributeNames
    /**
     * A list of names of instance groups that get data from the S3 data source.
     */
    public val instanceGroupNames: List<String>? = builder.instanceGroupNames
    /**
     * If you want SageMaker to replicate the entire dataset on each ML compute instance that is launched for model training, specify `FullyReplicated`.
     *
     * If you want SageMaker to replicate a subset of data on each ML compute instance that is launched for model training, specify `ShardedByS3Key`. If there are *n* ML compute instances launched for a training job, each instance gets approximately 1&#47;*n* of the number of S3 objects. In this case, model training on each machine uses only the subset of training data.
     *
     * Don't choose more ML compute instances for training than available S3 objects. If you do, some nodes won't get any data and you will pay for nodes that aren't getting any training data. This applies in both File and Pipe modes. Keep this in mind when developing algorithms.
     *
     * In distributed training, where you use multiple ML compute EC2 instances, you might choose `ShardedByS3Key`. If the algorithm requires copying training data to the ML storage volume (when `TrainingInputMode` is set to `File`), this copies 1&#47;*n* of the number of objects.
     */
    public val s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.S3DataDistribution? = builder.s3DataDistributionType
    /**
     * If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix for model training.
     *
     * If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.
     *
     * If you choose `AugmentedManifestFile`, S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. `AugmentedManifestFile` can only be used if the Channel's input mode is `Pipe`.
     */
    public val s3DataType: aws.sdk.kotlin.services.sagemaker.model.S3DataType? = builder.s3DataType
    /**
     * Depending on the value specified for the `S3DataType`, identifies either a key name prefix or a manifest. For example:
     * +  A key name prefix might look like this: `s3://bucketname/exampleprefix`
     * +  A manifest might look like this: `s3://bucketname/example.manifest` A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of `S3Uri`. Note that the prefix must be a valid non-empty `S3Uri` that precludes users from specifying a manifest whose individual `S3Uri` is sourced from different S3 buckets. The following code example shows a valid manifest format: `[ {"prefix": "s3://customer_bucket/some/prefix/"},`` "relative/path/to/custdata-1",`` "relative/path/custdata-2",`` ...`` "relative/path/custdata-N"``]` This JSON is equivalent to the following `S3Uri` list:`s3://customer_bucket/some/prefix/relative/path/to/custdata-1``s3://customer_bucket/some/prefix/relative/path/custdata-2``...``s3://customer_bucket/some/prefix/relative/path/custdata-N`The complete set of `S3Uri` in this manifest is the input data for the channel for this data source. The object that each `S3Uri` points to must be readable by the IAM role that SageMaker uses to perform tasks on your behalf.
     *
     * Your input bucket must be located in same Amazon Web Services region as your training job.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.S3DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataSource(")
        append("attributeNames=$attributeNames,")
        append("instanceGroupNames=$instanceGroupNames,")
        append("s3DataDistributionType=$s3DataDistributionType,")
        append("s3DataType=$s3DataType,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeNames?.hashCode() ?: 0
        result = 31 * result + (instanceGroupNames?.hashCode() ?: 0)
        result = 31 * result + (s3DataDistributionType?.hashCode() ?: 0)
        result = 31 * result + (s3DataType?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataSource

        if (attributeNames != other.attributeNames) return false
        if (instanceGroupNames != other.instanceGroupNames) return false
        if (s3DataDistributionType != other.s3DataDistributionType) return false
        if (s3DataType != other.s3DataType) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.S3DataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of one or more attribute names to use that are found in a specified augmented manifest file.
         */
        public var attributeNames: List<String>? = null
        /**
         * A list of names of instance groups that get data from the S3 data source.
         */
        public var instanceGroupNames: List<String>? = null
        /**
         * If you want SageMaker to replicate the entire dataset on each ML compute instance that is launched for model training, specify `FullyReplicated`.
         *
         * If you want SageMaker to replicate a subset of data on each ML compute instance that is launched for model training, specify `ShardedByS3Key`. If there are *n* ML compute instances launched for a training job, each instance gets approximately 1&#47;*n* of the number of S3 objects. In this case, model training on each machine uses only the subset of training data.
         *
         * Don't choose more ML compute instances for training than available S3 objects. If you do, some nodes won't get any data and you will pay for nodes that aren't getting any training data. This applies in both File and Pipe modes. Keep this in mind when developing algorithms.
         *
         * In distributed training, where you use multiple ML compute EC2 instances, you might choose `ShardedByS3Key`. If the algorithm requires copying training data to the ML storage volume (when `TrainingInputMode` is set to `File`), this copies 1&#47;*n* of the number of objects.
         */
        public var s3DataDistributionType: aws.sdk.kotlin.services.sagemaker.model.S3DataDistribution? = null
        /**
         * If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix for model training.
         *
         * If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.
         *
         * If you choose `AugmentedManifestFile`, S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. `AugmentedManifestFile` can only be used if the Channel's input mode is `Pipe`.
         */
        public var s3DataType: aws.sdk.kotlin.services.sagemaker.model.S3DataType? = null
        /**
         * Depending on the value specified for the `S3DataType`, identifies either a key name prefix or a manifest. For example:
         * +  A key name prefix might look like this: `s3://bucketname/exampleprefix`
         * +  A manifest might look like this: `s3://bucketname/example.manifest` A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of `S3Uri`. Note that the prefix must be a valid non-empty `S3Uri` that precludes users from specifying a manifest whose individual `S3Uri` is sourced from different S3 buckets. The following code example shows a valid manifest format: `[ {"prefix": "s3://customer_bucket/some/prefix/"},`` "relative/path/to/custdata-1",`` "relative/path/custdata-2",`` ...`` "relative/path/custdata-N"``]` This JSON is equivalent to the following `S3Uri` list:`s3://customer_bucket/some/prefix/relative/path/to/custdata-1``s3://customer_bucket/some/prefix/relative/path/custdata-2``...``s3://customer_bucket/some/prefix/relative/path/custdata-N`The complete set of `S3Uri` in this manifest is the input data for the channel for this data source. The object that each `S3Uri` points to must be readable by the IAM role that SageMaker uses to perform tasks on your behalf.
         *
         * Your input bucket must be located in same Amazon Web Services region as your training job.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.S3DataSource) : this() {
            this.attributeNames = x.attributeNames
            this.instanceGroupNames = x.instanceGroupNames
            this.s3DataDistributionType = x.s3DataDistributionType
            this.s3DataType = x.s3DataType
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.S3DataSource = S3DataSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
