// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
 */
public class RollingUpdatePolicy private constructor(builder: Builder) {
    /**
     * Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count.
     */
    public val maximumBatchSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = builder.maximumBatchSize
    /**
     * The time limit for the total deployment. Exceeding this limit causes a timeout.
     */
    public val maximumExecutionTimeoutInSeconds: kotlin.Int? = builder.maximumExecutionTimeoutInSeconds
    /**
     * Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
     */
    public val rollbackMaximumBatchSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = builder.rollbackMaximumBatchSize
    /**
     * The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
     */
    public val waitIntervalInSeconds: kotlin.Int? = builder.waitIntervalInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RollingUpdatePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RollingUpdatePolicy(")
        append("maximumBatchSize=$maximumBatchSize,")
        append("maximumExecutionTimeoutInSeconds=$maximumExecutionTimeoutInSeconds,")
        append("rollbackMaximumBatchSize=$rollbackMaximumBatchSize,")
        append("waitIntervalInSeconds=$waitIntervalInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumBatchSize?.hashCode() ?: 0
        result = 31 * result + (maximumExecutionTimeoutInSeconds ?: 0)
        result = 31 * result + (rollbackMaximumBatchSize?.hashCode() ?: 0)
        result = 31 * result + (waitIntervalInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RollingUpdatePolicy

        if (maximumBatchSize != other.maximumBatchSize) return false
        if (maximumExecutionTimeoutInSeconds != other.maximumExecutionTimeoutInSeconds) return false
        if (rollbackMaximumBatchSize != other.rollbackMaximumBatchSize) return false
        if (waitIntervalInSeconds != other.waitIntervalInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RollingUpdatePolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count.
         */
        public var maximumBatchSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = null
        /**
         * The time limit for the total deployment. Exceeding this limit causes a timeout.
         */
        public var maximumExecutionTimeoutInSeconds: kotlin.Int? = null
        /**
         * Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
         */
        public var rollbackMaximumBatchSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = null
        /**
         * The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet.
         */
        public var waitIntervalInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RollingUpdatePolicy) : this() {
            this.maximumBatchSize = x.maximumBatchSize
            this.maximumExecutionTimeoutInSeconds = x.maximumExecutionTimeoutInSeconds
            this.rollbackMaximumBatchSize = x.rollbackMaximumBatchSize
            this.waitIntervalInSeconds = x.waitIntervalInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RollingUpdatePolicy = RollingUpdatePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CapacitySize] inside the given [block]
         */
        public fun maximumBatchSize(block: aws.sdk.kotlin.services.sagemaker.model.CapacitySize.Builder.() -> kotlin.Unit) {
            this.maximumBatchSize = aws.sdk.kotlin.services.sagemaker.model.CapacitySize.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CapacitySize] inside the given [block]
         */
        public fun rollbackMaximumBatchSize(block: aws.sdk.kotlin.services.sagemaker.model.CapacitySize.Builder.() -> kotlin.Unit) {
            this.rollbackMaximumBatchSize = aws.sdk.kotlin.services.sagemaker.model.CapacitySize.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
