// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the resources, including machine learning (ML) compute instances and ML storage volumes, to use for model training.
 */
public class ResourceConfig private constructor(builder: Builder) {
    /**
     * The number of ML compute instances to use. For distributed training, provide a value greater than 1.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The configuration of a heterogeneous cluster in JSON format.
     */
    public val instanceGroups: List<InstanceGroup>? = builder.instanceGroups
    /**
     * The ML compute instance type.
     *
     * SageMaker Training on Amazon Elastic Compute Cloud (EC2) P4de instances is in preview release starting December 9th, 2022.
     *
     * [Amazon EC2 P4de instances](http://aws.amazon.com/ec2/instance-types/p4/) (currently in preview) are powered by 8 NVIDIA A100 GPUs with 80GB high-performance HBM2e GPU memory, which accelerate the speed of training ML models that need to be trained on large datasets of high-resolution data. In this preview release, Amazon SageMaker supports ML training jobs on P4de instances (`ml.p4de.24xlarge`) to reduce model training time. The `ml.p4de.24xlarge` instances are available in the following Amazon Web Services Regions.
     * + US East (N. Virginia) (us-east-1)
     * + US West (Oregon) (us-west-2)
     * To request quota limit increase and start using P4de instances, contact the SageMaker Training service team through your account team.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = builder.instanceType
    /**
     * The duration of time in seconds to retain configured resources in a warm pool for subsequent training jobs.
     */
    public val keepAlivePeriodInSeconds: kotlin.Int? = builder.keepAlivePeriodInSeconds
    /**
     * The Amazon Web Services KMS key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
     *
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `VolumeKmsKeyId` when using an instance type with local storage.
     *
     * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
     *
     * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
     *
     * The `VolumeKmsKeyId` can be in any of the following formats:
     * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * The size of the ML storage volume that you want to provision.
     *
     * ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML storage volume for scratch space. If you want to store the training data in the ML storage volume, choose `File` as the `TrainingInputMode` in the algorithm specification.
     *
     * When using an ML instance with [NVMe SSD volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html#nvme-ssd-volumes), SageMaker doesn't provision Amazon EBS General Purpose SSD (gp2) storage. Available storage is fixed to the NVMe-type instance's storage capacity. SageMaker configures storage paths for training datasets, checkpoints, model artifacts, and outputs to use the entire capacity of the instance storage. For example, ML instance families with the NVMe-type instance storage include `ml.p4d`, `ml.g4dn`, and `ml.g5`.
     *
     * When using an ML instance with the EBS-only storage option and without instance storage, you must define the size of EBS volume through `VolumeSizeInGB` in the `ResourceConfig` API. For example, ML instance families that use EBS volumes include `ml.c5` and `ml.p2`.
     *
     * To look up instance types and their instance storage types and volumes, see [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/).
     *
     * To find the default local paths defined by the SageMaker training platform, see [Amazon SageMaker Training Storage Folders for Training Datasets, Checkpoints, Model Artifacts, and Outputs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-train-storage.html).
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ResourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceConfig(")
        append("instanceCount=$instanceCount,")
        append("instanceGroups=$instanceGroups,")
        append("instanceType=$instanceType,")
        append("keepAlivePeriodInSeconds=$keepAlivePeriodInSeconds,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount ?: 0
        result = 31 * result + (instanceGroups?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (keepAlivePeriodInSeconds ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceConfig

        if (instanceCount != other.instanceCount) return false
        if (instanceGroups != other.instanceGroups) return false
        if (instanceType != other.instanceType) return false
        if (keepAlivePeriodInSeconds != other.keepAlivePeriodInSeconds) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ResourceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of ML compute instances to use. For distributed training, provide a value greater than 1.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The configuration of a heterogeneous cluster in JSON format.
         */
        public var instanceGroups: List<InstanceGroup>? = null
        /**
         * The ML compute instance type.
         *
         * SageMaker Training on Amazon Elastic Compute Cloud (EC2) P4de instances is in preview release starting December 9th, 2022.
         *
         * [Amazon EC2 P4de instances](http://aws.amazon.com/ec2/instance-types/p4/) (currently in preview) are powered by 8 NVIDIA A100 GPUs with 80GB high-performance HBM2e GPU memory, which accelerate the speed of training ML models that need to be trained on large datasets of high-resolution data. In this preview release, Amazon SageMaker supports ML training jobs on P4de instances (`ml.p4de.24xlarge`) to reduce model training time. The `ml.p4de.24xlarge` instances are available in the following Amazon Web Services Regions.
         * + US East (N. Virginia) (us-east-1)
         * + US West (Oregon) (us-west-2)
         * To request quota limit increase and start using P4de instances, contact the SageMaker Training service team through your account team.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.TrainingInstanceType? = null
        /**
         * The duration of time in seconds to retain configured resources in a warm pool for subsequent training jobs.
         */
        public var keepAlivePeriodInSeconds: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
         *
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a `VolumeKmsKeyId` when using an instance type with local storage.
         *
         * For a list of instance types that support local instance storage, see [Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
         *
         * For more information about local instance storage encryption, see [SSD Instance Store Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
         *
         * The `VolumeKmsKeyId` can be in any of the following formats:
         * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * The size of the ML storage volume that you want to provision.
         *
         * ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML storage volume for scratch space. If you want to store the training data in the ML storage volume, choose `File` as the `TrainingInputMode` in the algorithm specification.
         *
         * When using an ML instance with [NVMe SSD volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html#nvme-ssd-volumes), SageMaker doesn't provision Amazon EBS General Purpose SSD (gp2) storage. Available storage is fixed to the NVMe-type instance's storage capacity. SageMaker configures storage paths for training datasets, checkpoints, model artifacts, and outputs to use the entire capacity of the instance storage. For example, ML instance families with the NVMe-type instance storage include `ml.p4d`, `ml.g4dn`, and `ml.g5`.
         *
         * When using an ML instance with the EBS-only storage option and without instance storage, you must define the size of EBS volume through `VolumeSizeInGB` in the `ResourceConfig` API. For example, ML instance families that use EBS volumes include `ml.c5` and `ml.p2`.
         *
         * To look up instance types and their instance storage types and volumes, see [Amazon EC2 Instance Types](http://aws.amazon.com/ec2/instance-types/).
         *
         * To find the default local paths defined by the SageMaker training platform, see [Amazon SageMaker Training Storage Folders for Training Datasets, Checkpoints, Model Artifacts, and Outputs](https://docs.aws.amazon.com/sagemaker/latest/dg/model-train-storage.html).
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig) : this() {
            this.instanceCount = x.instanceCount
            this.instanceGroups = x.instanceGroups
            this.instanceType = x.instanceType
            this.keepAlivePeriodInSeconds = x.keepAlivePeriodInSeconds
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ResourceConfig = ResourceConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
