// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The input configuration of the recommendation job.
 */
public class RecommendationJobInputConfig private constructor(builder: Builder) {
    /**
     * Specifies mandatory fields for running an Inference Recommender job. The fields specified in `ContainerConfig` override the corresponding fields in the model package.
     */
    public val containerConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig? = builder.containerConfig
    /**
     * Specifies the endpoint configuration to use for a job.
     */
    public val endpointConfigurations: List<EndpointInputConfiguration>? = builder.endpointConfigurations
    /**
     * Existing customer endpoints on which to run an Inference Recommender job.
     */
    public val endpoints: List<EndpointInfo>? = builder.endpoints
    /**
     * Specifies the maximum duration of the job, in seconds. The maximum value is 18,000 seconds.
     */
    public val jobDurationInSeconds: kotlin.Int? = builder.jobDurationInSeconds
    /**
     * The name of the created model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The Amazon Resource Name (ARN) of a versioned model package.
     */
    public val modelPackageVersionArn: kotlin.String? = builder.modelPackageVersionArn
    /**
     * Defines the resource limit of the job.
     */
    public val resourceLimit: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobResourceLimit? = builder.resourceLimit
    /**
     * Specifies the traffic pattern of the job.
     */
    public val trafficPattern: aws.sdk.kotlin.services.sagemaker.model.TrafficPattern? = builder.trafficPattern
    /**
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. This key will be passed to SageMaker Hosting for endpoint creation.
     *
     * The SageMaker execution role must have `kms:CreateGrant` permission in order to encrypt data on the storage volume of the endpoints created for inference recommendation. The inference recommendation job will fail asynchronously during endpoint configuration creation if the role passed does not have `kms:CreateGrant` permission.
     *
     * The `KmsKeyId` can be any of the following formats:
     * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:<region>:<account>:key/<key-id-12ab-34cd-56ef-1234567890ab>"`
     * + // KMS Key Alias`"alias/ExampleAlias"`
     * + // Amazon Resource Name (ARN) of a KMS Key Alias`"arn:aws:kms:<region>:<account>:alias/<ExampleAlias>"`
     *
     * For more information about key identifiers, see [Key identifiers (KeyID)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id) in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Inference Recommender provisions SageMaker endpoints with access to VPC in the inference recommendation job.
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationJobInputConfig(")
        append("containerConfig=$containerConfig,")
        append("endpointConfigurations=$endpointConfigurations,")
        append("endpoints=$endpoints,")
        append("jobDurationInSeconds=$jobDurationInSeconds,")
        append("modelName=$modelName,")
        append("modelPackageVersionArn=$modelPackageVersionArn,")
        append("resourceLimit=$resourceLimit,")
        append("trafficPattern=$trafficPattern,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerConfig?.hashCode() ?: 0
        result = 31 * result + (endpointConfigurations?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (jobDurationInSeconds ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersionArn?.hashCode() ?: 0)
        result = 31 * result + (resourceLimit?.hashCode() ?: 0)
        result = 31 * result + (trafficPattern?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationJobInputConfig

        if (containerConfig != other.containerConfig) return false
        if (endpointConfigurations != other.endpointConfigurations) return false
        if (endpoints != other.endpoints) return false
        if (jobDurationInSeconds != other.jobDurationInSeconds) return false
        if (modelName != other.modelName) return false
        if (modelPackageVersionArn != other.modelPackageVersionArn) return false
        if (resourceLimit != other.resourceLimit) return false
        if (trafficPattern != other.trafficPattern) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies mandatory fields for running an Inference Recommender job. The fields specified in `ContainerConfig` override the corresponding fields in the model package.
         */
        public var containerConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig? = null
        /**
         * Specifies the endpoint configuration to use for a job.
         */
        public var endpointConfigurations: List<EndpointInputConfiguration>? = null
        /**
         * Existing customer endpoints on which to run an Inference Recommender job.
         */
        public var endpoints: List<EndpointInfo>? = null
        /**
         * Specifies the maximum duration of the job, in seconds. The maximum value is 18,000 seconds.
         */
        public var jobDurationInSeconds: kotlin.Int? = null
        /**
         * The name of the created model.
         */
        public var modelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a versioned model package.
         */
        public var modelPackageVersionArn: kotlin.String? = null
        /**
         * Defines the resource limit of the job.
         */
        public var resourceLimit: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobResourceLimit? = null
        /**
         * Specifies the traffic pattern of the job.
         */
        public var trafficPattern: aws.sdk.kotlin.services.sagemaker.model.TrafficPattern? = null
        /**
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. This key will be passed to SageMaker Hosting for endpoint creation.
         *
         * The SageMaker execution role must have `kms:CreateGrant` permission in order to encrypt data on the storage volume of the endpoints created for inference recommendation. The inference recommendation job will fail asynchronously during endpoint configuration creation if the role passed does not have `kms:CreateGrant` permission.
         *
         * The `KmsKeyId` can be any of the following formats:
         * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:<region>:<account>:key/<key-id-12ab-34cd-56ef-1234567890ab>"`
         * + // KMS Key Alias`"alias/ExampleAlias"`
         * + // Amazon Resource Name (ARN) of a KMS Key Alias`"arn:aws:kms:<region>:<account>:alias/<ExampleAlias>"`
         *
         * For more information about key identifiers, see [Key identifiers (KeyID)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id) in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Inference Recommender provisions SageMaker endpoints with access to VPC in the inference recommendation job.
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig) : this() {
            this.containerConfig = x.containerConfig
            this.endpointConfigurations = x.endpointConfigurations
            this.endpoints = x.endpoints
            this.jobDurationInSeconds = x.jobDurationInSeconds
            this.modelName = x.modelName
            this.modelPackageVersionArn = x.modelPackageVersionArn
            this.resourceLimit = x.resourceLimit
            this.trafficPattern = x.trafficPattern
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig = RecommendationJobInputConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig] inside the given [block]
         */
        public fun containerConfig(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig.Builder.() -> kotlin.Unit) {
            this.containerConfig = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobResourceLimit] inside the given [block]
         */
        public fun resourceLimit(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobResourceLimit.Builder.() -> kotlin.Unit) {
            this.resourceLimit = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobResourceLimit.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrafficPattern] inside the given [block]
         */
        public fun trafficPattern(block: aws.sdk.kotlin.services.sagemaker.model.TrafficPattern.Builder.() -> kotlin.Unit) {
            this.trafficPattern = aws.sdk.kotlin.services.sagemaker.model.TrafficPattern.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobVpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
