// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Provides information about how to store model training results (model artifacts).
 */
public class OutputDataConfig private constructor(builder: Builder) {
    /**
     * The model output compression type. Select `None` to output an uncompressed model, recommended for large model outputs. Defaults to gzip.
     */
    public val compressionType: aws.sdk.kotlin.services.sagemaker.model.OutputCompressionType? = builder.compressionType
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The `KmsKeyId` can be any of the following formats:
     * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + // KMS Key Alias`"alias/ExampleAlias"`
     * + // Amazon Resource Name (ARN) of a KMS Key Alias`"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
     *
     * If you use a KMS key ID or an alias of your KMS key, the SageMaker execution role must include permissions to call `kms:Encrypt`. If you don't provide a KMS key ID, SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see [KMS-Managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide*. If the output data is stored in Amazon S3 Express One Zone, it is encrypted with server-side encryption with Amazon S3 managed keys (SSE-S3). KMS key is not supported for Amazon S3 Express One Zone
     *
     * The KMS key policy must grant permission to the IAM role that you specify in your `CreateTrainingJob`, `CreateTransformJob`, or `CreateHyperParameterTuningJob` requests. For more information, see [Using Key Policies in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Amazon Web Services Key Management Service Developer Guide*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Identifies the S3 path where you want SageMaker to store the model artifacts. For example, `s3://bucket-name/key-name-prefix`.
     */
    public val s3OutputPath: kotlin.String? = builder.s3OutputPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputDataConfig(")
        append("compressionType=$compressionType,")
        append("kmsKeyId=$kmsKeyId,")
        append("s3OutputPath=$s3OutputPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionType?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputDataConfig

        if (compressionType != other.compressionType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The model output compression type. Select `None` to output an uncompressed model, recommended for large model outputs. Defaults to gzip.
         */
        public var compressionType: aws.sdk.kotlin.services.sagemaker.model.OutputCompressionType? = null
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The `KmsKeyId` can be any of the following formats:
         * + // KMS Key ID`"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + // Amazon Resource Name (ARN) of a KMS Key`"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + // KMS Key Alias`"alias/ExampleAlias"`
         * + // Amazon Resource Name (ARN) of a KMS Key Alias`"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
         *
         * If you use a KMS key ID or an alias of your KMS key, the SageMaker execution role must include permissions to call `kms:Encrypt`. If you don't provide a KMS key ID, SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see [KMS-Managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide*. If the output data is stored in Amazon S3 Express One Zone, it is encrypted with server-side encryption with Amazon S3 managed keys (SSE-S3). KMS key is not supported for Amazon S3 Express One Zone
         *
         * The KMS key policy must grant permission to the IAM role that you specify in your `CreateTrainingJob`, `CreateTransformJob`, or `CreateHyperParameterTuningJob` requests. For more information, see [Using Key Policies in Amazon Web Services KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Amazon Web Services Key Management Service Developer Guide*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Identifies the S3 path where you want SageMaker to store the model artifacts. For example, `s3://bucket-name/key-name-prefix`.
         */
        public var s3OutputPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig) : this() {
            this.compressionType = x.compressionType
            this.kmsKeyId = x.kmsKeyId
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig = OutputDataConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
