// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A schedule for a model monitoring job. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
 */
public class MonitoringSchedule private constructor(builder: Builder) {
    /**
     * The time that the monitoring schedule was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The endpoint that hosts the model being monitored.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * If the monitoring schedule failed, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The last time the monitoring schedule was changed.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Summary of information about the last monitoring job to run.
     */
    public val lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = builder.lastMonitoringExecutionSummary
    /**
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    public val monitoringScheduleArn: kotlin.String? = builder.monitoringScheduleArn
    /**
     * Configures the monitoring schedule and defines the monitoring job.
     */
    public val monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = builder.monitoringScheduleConfig
    /**
     * The name of the monitoring schedule.
     */
    public val monitoringScheduleName: kotlin.String? = builder.monitoringScheduleName
    /**
     * The status of the monitoring schedule. This can be one of the following values.
     * + `PENDING` - The schedule is pending being created.
     * + `FAILED` - The schedule failed.
     * + `SCHEDULED` - The schedule was successfully created.
     * + `STOPPED` - The schedule was stopped.
     */
    public val monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = builder.monitoringScheduleStatus
    /**
     * The type of the monitoring job definition to schedule.
     */
    public val monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = builder.monitoringType
    /**
     * A list of the tags associated with the monitoring schedlue. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringSchedule(")
        append("creationTime=$creationTime,")
        append("endpointName=$endpointName,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("lastMonitoringExecutionSummary=$lastMonitoringExecutionSummary,")
        append("monitoringScheduleArn=$monitoringScheduleArn,")
        append("monitoringScheduleConfig=$monitoringScheduleConfig,")
        append("monitoringScheduleName=$monitoringScheduleName,")
        append("monitoringScheduleStatus=$monitoringScheduleStatus,")
        append("monitoringType=$monitoringType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (lastMonitoringExecutionSummary?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleArn?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleConfig?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleName?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleStatus?.hashCode() ?: 0)
        result = 31 * result + (monitoringType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringSchedule

        if (creationTime != other.creationTime) return false
        if (endpointName != other.endpointName) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (lastMonitoringExecutionSummary != other.lastMonitoringExecutionSummary) return false
        if (monitoringScheduleArn != other.monitoringScheduleArn) return false
        if (monitoringScheduleConfig != other.monitoringScheduleConfig) return false
        if (monitoringScheduleName != other.monitoringScheduleName) return false
        if (monitoringScheduleStatus != other.monitoringScheduleStatus) return false
        if (monitoringType != other.monitoringType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringSchedule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time that the monitoring schedule was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoint that hosts the model being monitored.
         */
        public var endpointName: kotlin.String? = null
        /**
         * If the monitoring schedule failed, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The last time the monitoring schedule was changed.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Summary of information about the last monitoring job to run.
         */
        public var lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = null
        /**
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         */
        public var monitoringScheduleArn: kotlin.String? = null
        /**
         * Configures the monitoring schedule and defines the monitoring job.
         */
        public var monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = null
        /**
         * The name of the monitoring schedule.
         */
        public var monitoringScheduleName: kotlin.String? = null
        /**
         * The status of the monitoring schedule. This can be one of the following values.
         * + `PENDING` - The schedule is pending being created.
         * + `FAILED` - The schedule failed.
         * + `SCHEDULED` - The schedule was successfully created.
         * + `STOPPED` - The schedule was stopped.
         */
        public var monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = null
        /**
         * The type of the monitoring job definition to schedule.
         */
        public var monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = null
        /**
         * A list of the tags associated with the monitoring schedlue. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringSchedule) : this() {
            this.creationTime = x.creationTime
            this.endpointName = x.endpointName
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.lastMonitoringExecutionSummary = x.lastMonitoringExecutionSummary
            this.monitoringScheduleArn = x.monitoringScheduleArn
            this.monitoringScheduleConfig = x.monitoringScheduleConfig
            this.monitoringScheduleName = x.monitoringScheduleName
            this.monitoringScheduleStatus = x.monitoringScheduleStatus
            this.monitoringType = x.monitoringType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringSchedule = MonitoringSchedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary] inside the given [block]
         */
        public fun lastMonitoringExecutionSummary(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.Builder.() -> kotlin.Unit) {
            this.lastMonitoringExecutionSummary = aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig] inside the given [block]
         */
        public fun monitoringScheduleConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.Builder.() -> kotlin.Unit) {
            this.monitoringScheduleConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
