// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Docker container image configuration object for the model explainability job.
 */
public class ModelExplainabilityAppSpecification private constructor(builder: Builder) {
    /**
     * JSON formatted Amazon S3 file that defines explainability parameters. For more information on this JSON configuration file, see [Configure model explainability parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html).
     */
    public val configUri: kotlin.String? = builder.configUri
    /**
     * Sets the environment variables in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The container image to be run by the model explainability job.
     */
    public val imageUri: kotlin.String? = builder.imageUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityAppSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelExplainabilityAppSpecification(")
        append("configUri=$configUri,")
        append("environment=$environment,")
        append("imageUri=$imageUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configUri?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelExplainabilityAppSpecification

        if (configUri != other.configUri) return false
        if (environment != other.environment) return false
        if (imageUri != other.imageUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityAppSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * JSON formatted Amazon S3 file that defines explainability parameters. For more information on this JSON configuration file, see [Configure model explainability parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html).
         */
        public var configUri: kotlin.String? = null
        /**
         * Sets the environment variables in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * The container image to be run by the model explainability job.
         */
        public var imageUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityAppSpecification) : this() {
            this.configUri = x.configUri
            this.environment = x.environment
            this.imageUri = x.imageUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelExplainabilityAppSpecification = ModelExplainabilityAppSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
