// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A monitoring schedule for a model displayed in the Amazon SageMaker Model Dashboard.
 */
public class ModelDashboardMonitoringSchedule private constructor(builder: Builder) {
    /**
     * Input object for the batch transform job.
     */
    public val batchTransformInput: aws.sdk.kotlin.services.sagemaker.model.BatchTransformInput? = builder.batchTransformInput
    /**
     * A timestamp that indicates when the monitoring schedule was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The endpoint which is monitored.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * If a monitoring job failed, provides the reason.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * A timestamp that indicates when the monitoring schedule was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Summary of information about the last monitoring job to run.
     */
    public val lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = builder.lastMonitoringExecutionSummary
    /**
     * A JSON array where each element is a summary for a monitoring alert.
     */
    public val monitoringAlertSummaries: List<MonitoringAlertSummary>? = builder.monitoringAlertSummaries
    /**
     * The Amazon Resource Name (ARN) of a monitoring schedule.
     */
    public val monitoringScheduleArn: kotlin.String? = builder.monitoringScheduleArn
    /**
     * Configures the monitoring schedule and defines the monitoring job.
     */
    public val monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = builder.monitoringScheduleConfig
    /**
     * The name of a monitoring schedule.
     */
    public val monitoringScheduleName: kotlin.String? = builder.monitoringScheduleName
    /**
     * The status of the monitoring schedule.
     */
    public val monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = builder.monitoringScheduleStatus
    /**
     * The monitor type of a model monitor.
     */
    public val monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = builder.monitoringType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardMonitoringSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelDashboardMonitoringSchedule(")
        append("batchTransformInput=$batchTransformInput,")
        append("creationTime=$creationTime,")
        append("endpointName=$endpointName,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("lastMonitoringExecutionSummary=$lastMonitoringExecutionSummary,")
        append("monitoringAlertSummaries=$monitoringAlertSummaries,")
        append("monitoringScheduleArn=$monitoringScheduleArn,")
        append("monitoringScheduleConfig=$monitoringScheduleConfig,")
        append("monitoringScheduleName=$monitoringScheduleName,")
        append("monitoringScheduleStatus=$monitoringScheduleStatus,")
        append("monitoringType=$monitoringType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchTransformInput?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (lastMonitoringExecutionSummary?.hashCode() ?: 0)
        result = 31 * result + (monitoringAlertSummaries?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleArn?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleConfig?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleName?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleStatus?.hashCode() ?: 0)
        result = 31 * result + (monitoringType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelDashboardMonitoringSchedule

        if (batchTransformInput != other.batchTransformInput) return false
        if (creationTime != other.creationTime) return false
        if (endpointName != other.endpointName) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (lastMonitoringExecutionSummary != other.lastMonitoringExecutionSummary) return false
        if (monitoringAlertSummaries != other.monitoringAlertSummaries) return false
        if (monitoringScheduleArn != other.monitoringScheduleArn) return false
        if (monitoringScheduleConfig != other.monitoringScheduleConfig) return false
        if (monitoringScheduleName != other.monitoringScheduleName) return false
        if (monitoringScheduleStatus != other.monitoringScheduleStatus) return false
        if (monitoringType != other.monitoringType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardMonitoringSchedule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Input object for the batch transform job.
         */
        public var batchTransformInput: aws.sdk.kotlin.services.sagemaker.model.BatchTransformInput? = null
        /**
         * A timestamp that indicates when the monitoring schedule was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoint which is monitored.
         */
        public var endpointName: kotlin.String? = null
        /**
         * If a monitoring job failed, provides the reason.
         */
        public var failureReason: kotlin.String? = null
        /**
         * A timestamp that indicates when the monitoring schedule was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Summary of information about the last monitoring job to run.
         */
        public var lastMonitoringExecutionSummary: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary? = null
        /**
         * A JSON array where each element is a summary for a monitoring alert.
         */
        public var monitoringAlertSummaries: List<MonitoringAlertSummary>? = null
        /**
         * The Amazon Resource Name (ARN) of a monitoring schedule.
         */
        public var monitoringScheduleArn: kotlin.String? = null
        /**
         * Configures the monitoring schedule and defines the monitoring job.
         */
        public var monitoringScheduleConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig? = null
        /**
         * The name of a monitoring schedule.
         */
        public var monitoringScheduleName: kotlin.String? = null
        /**
         * The status of the monitoring schedule.
         */
        public var monitoringScheduleStatus: aws.sdk.kotlin.services.sagemaker.model.ScheduleStatus? = null
        /**
         * The monitor type of a model monitor.
         */
        public var monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelDashboardMonitoringSchedule) : this() {
            this.batchTransformInput = x.batchTransformInput
            this.creationTime = x.creationTime
            this.endpointName = x.endpointName
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.lastMonitoringExecutionSummary = x.lastMonitoringExecutionSummary
            this.monitoringAlertSummaries = x.monitoringAlertSummaries
            this.monitoringScheduleArn = x.monitoringScheduleArn
            this.monitoringScheduleConfig = x.monitoringScheduleConfig
            this.monitoringScheduleName = x.monitoringScheduleName
            this.monitoringScheduleStatus = x.monitoringScheduleStatus
            this.monitoringType = x.monitoringType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardMonitoringSchedule = ModelDashboardMonitoringSchedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.BatchTransformInput] inside the given [block]
         */
        public fun batchTransformInput(block: aws.sdk.kotlin.services.sagemaker.model.BatchTransformInput.Builder.() -> kotlin.Unit) {
            this.batchTransformInput = aws.sdk.kotlin.services.sagemaker.model.BatchTransformInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary] inside the given [block]
         */
        public fun lastMonitoringExecutionSummary(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.Builder.() -> kotlin.Unit) {
            this.lastMonitoringExecutionSummary = aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig] inside the given [block]
         */
        public fun monitoringScheduleConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.Builder.() -> kotlin.Unit) {
            this.monitoringScheduleConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringScheduleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
