// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The properties of a model as returned by the [Search](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html) API.
 */
public class Model private constructor(builder: Builder) {
    /**
     * The containers in the inference pipeline.
     */
    public val containers: List<ContainerDefinition>? = builder.containers
    /**
     * A timestamp that indicates when the model was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A set of recommended deployment configurations for the model.
     */
    public val deploymentRecommendation: aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation? = builder.deploymentRecommendation
    /**
     * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    public val enableNetworkIsolation: kotlin.Boolean? = builder.enableNetworkIsolation
    /**
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Specifies details about how containers in a multi-container endpoint are run.
     */
    public val inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = builder.inferenceExecutionConfig
    /**
     * The Amazon Resource Name (ARN) of the model.
     */
    public val modelArn: kotlin.String? = builder.modelArn
    /**
     * The name of the model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Describes the container, as part of model definition.
     */
    public val primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = builder.primaryContainer
    /**
     * A list of key-value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.Model = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Model(")
        append("containers=$containers,")
        append("creationTime=$creationTime,")
        append("deploymentRecommendation=$deploymentRecommendation,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("executionRoleArn=$executionRoleArn,")
        append("inferenceExecutionConfig=$inferenceExecutionConfig,")
        append("modelArn=$modelArn,")
        append("modelName=$modelName,")
        append("primaryContainer=$primaryContainer,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentRecommendation?.hashCode() ?: 0)
        result = 31 * result + (enableNetworkIsolation?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inferenceExecutionConfig?.hashCode() ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (primaryContainer?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Model

        if (containers != other.containers) return false
        if (creationTime != other.creationTime) return false
        if (deploymentRecommendation != other.deploymentRecommendation) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inferenceExecutionConfig != other.inferenceExecutionConfig) return false
        if (modelArn != other.modelArn) return false
        if (modelName != other.modelName) return false
        if (primaryContainer != other.primaryContainer) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.Model = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The containers in the inference pipeline.
         */
        public var containers: List<ContainerDefinition>? = null
        /**
         * A timestamp that indicates when the model was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A set of recommended deployment configurations for the model.
         */
        public var deploymentRecommendation: aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation? = null
        /**
         * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
         */
        public var enableNetworkIsolation: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * Specifies details about how containers in a multi-container endpoint are run.
         */
        public var inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * The name of the model.
         */
        public var modelName: kotlin.String? = null
        /**
         * Describes the container, as part of model definition.
         */
        public var primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = null
        /**
         * A list of key-value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.Model) : this() {
            this.containers = x.containers
            this.creationTime = x.creationTime
            this.deploymentRecommendation = x.deploymentRecommendation
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.executionRoleArn = x.executionRoleArn
            this.inferenceExecutionConfig = x.inferenceExecutionConfig
            this.modelArn = x.modelArn
            this.modelName = x.modelName
            this.primaryContainer = x.primaryContainer
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.Model = Model(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation] inside the given [block]
         */
        public fun deploymentRecommendation(block: aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation.Builder.() -> kotlin.Unit) {
            this.deploymentRecommendation = aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig] inside the given [block]
         */
        public fun inferenceExecutionConfig(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.Builder.() -> kotlin.Unit) {
            this.inferenceExecutionConfig = aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition] inside the given [block]
         */
        public fun primaryContainer(block: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.Builder.() -> kotlin.Unit) {
            this.primaryContainer = aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
