// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListClustersRequest private constructor(builder: Builder) {
    /**
     * Set a start time for the time range during which you want to list SageMaker HyperPod clusters. Timestamps are formatted according to the ISO 8601 standard.
     *
     * Acceptable formats include:
     * + `YYYY-MM-DDThh:mm:ss.sssTZD` (UTC), for example, `2014-10-01T20:30:00.000Z`
     * + `YYYY-MM-DDThh:mm:ss.sssTZD` (with offset), for example, `2014-10-01T12:30:00.000-08:00`
     * + `YYYY-MM-DD`, for example, `2014-10-01`
     * + Unix time in seconds, for example, `1412195400`. This is also referred to as Unix Epoch time and represents the number of seconds since midnight, January 1, 1970 UTC.
     *
     * For more information about the timestamp format, see [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) in the *Amazon Web Services Command Line Interface User Guide*.
     */
    public val creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeAfter
    /**
     * Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter that returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable formats are the same as the timestamp formats for `CreationTimeAfter`. For more information about the timestamp format, see [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) in the *Amazon Web Services Command Line Interface User Guide*.
     */
    public val creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeBefore
    /**
     * Set the maximum number of SageMaker HyperPod clusters to list.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Set the maximum number of instances to print in the list.
     */
    public val nameContains: kotlin.String? = builder.nameContains
    /**
     * Set the next token to retrieve the list of SageMaker HyperPod clusters.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The field by which to sort results. The default value is `CREATION_TIME`.
     */
    public val sortBy: aws.sdk.kotlin.services.sagemaker.model.ClusterSortBy? = builder.sortBy
    /**
     * The sort order for results. The default value is `Ascending`.
     */
    public val sortOrder: aws.sdk.kotlin.services.sagemaker.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ListClustersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListClustersRequest(")
        append("creationTimeAfter=$creationTimeAfter,")
        append("creationTimeBefore=$creationTimeBefore,")
        append("maxResults=$maxResults,")
        append("nameContains=$nameContains,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimeAfter?.hashCode() ?: 0
        result = 31 * result + (creationTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nameContains?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListClustersRequest

        if (creationTimeAfter != other.creationTimeAfter) return false
        if (creationTimeBefore != other.creationTimeBefore) return false
        if (maxResults != other.maxResults) return false
        if (nameContains != other.nameContains) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ListClustersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set a start time for the time range during which you want to list SageMaker HyperPod clusters. Timestamps are formatted according to the ISO 8601 standard.
         *
         * Acceptable formats include:
         * + `YYYY-MM-DDThh:mm:ss.sssTZD` (UTC), for example, `2014-10-01T20:30:00.000Z`
         * + `YYYY-MM-DDThh:mm:ss.sssTZD` (with offset), for example, `2014-10-01T12:30:00.000-08:00`
         * + `YYYY-MM-DD`, for example, `2014-10-01`
         * + Unix time in seconds, for example, `1412195400`. This is also referred to as Unix Epoch time and represents the number of seconds since midnight, January 1, 1970 UTC.
         *
         * For more information about the timestamp format, see [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) in the *Amazon Web Services Command Line Interface User Guide*.
         */
        public var creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Set an end time for the time range during which you want to list SageMaker HyperPod clusters. A filter that returns nodes in a SageMaker HyperPod cluster created before the specified time. The acceptable formats are the same as the timestamp formats for `CreationTimeAfter`. For more information about the timestamp format, see [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) in the *Amazon Web Services Command Line Interface User Guide*.
         */
        public var creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Set the maximum number of SageMaker HyperPod clusters to list.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Set the maximum number of instances to print in the list.
         */
        public var nameContains: kotlin.String? = null
        /**
         * Set the next token to retrieve the list of SageMaker HyperPod clusters.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The field by which to sort results. The default value is `CREATION_TIME`.
         */
        public var sortBy: aws.sdk.kotlin.services.sagemaker.model.ClusterSortBy? = null
        /**
         * The sort order for results. The default value is `Ascending`.
         */
        public var sortOrder: aws.sdk.kotlin.services.sagemaker.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ListClustersRequest) : this() {
            this.creationTimeAfter = x.creationTimeAfter
            this.creationTimeBefore = x.creationTimeBefore
            this.maxResults = x.maxResults
            this.nameContains = x.nameContains
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ListClustersRequest = ListClustersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
