// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains a list of recommendation jobs.
 */
public class InferenceRecommendationsJob private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the job completed.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * A timestamp that shows when the job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If the job fails, provides information why the job failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the recommendation job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The job description.
     */
    public val jobDescription: kotlin.String? = builder.jobDescription
    /**
     * The name of the job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The recommendation job type.
     */
    public val jobType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobType? = builder.jobType
    /**
     * A timestamp that shows when the job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the created model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The Amazon Resource Name (ARN) of a versioned model package.
     */
    public val modelPackageVersionArn: kotlin.String? = builder.modelPackageVersionArn
    /**
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public val samplePayloadUrl: kotlin.String? = builder.samplePayloadUrl
    /**
     * The status of the job.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceRecommendationsJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceRecommendationsJob(")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("jobArn=$jobArn,")
        append("jobDescription=$jobDescription,")
        append("jobName=$jobName,")
        append("jobType=$jobType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelName=$modelName,")
        append("modelPackageVersionArn=$modelPackageVersionArn,")
        append("roleArn=$roleArn,")
        append("samplePayloadUrl=$samplePayloadUrl,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobDescription?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersionArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (samplePayloadUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceRecommendationsJob

        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (jobArn != other.jobArn) return false
        if (jobDescription != other.jobDescription) return false
        if (jobName != other.jobName) return false
        if (jobType != other.jobType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelName != other.modelName) return false
        if (modelPackageVersionArn != other.modelPackageVersionArn) return false
        if (roleArn != other.roleArn) return false
        if (samplePayloadUrl != other.samplePayloadUrl) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceRecommendationsJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp that shows when the job completed.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that shows when the job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the job fails, provides information why the job failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the recommendation job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The job description.
         */
        public var jobDescription: kotlin.String? = null
        /**
         * The name of the job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The recommendation job type.
         */
        public var jobType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobType? = null
        /**
         * A timestamp that shows when the job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the created model.
         */
        public var modelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a versioned model package.
         */
        public var modelPackageVersionArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         */
        public var samplePayloadUrl: kotlin.String? = null
        /**
         * The status of the job.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceRecommendationsJob) : this() {
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.jobArn = x.jobArn
            this.jobDescription = x.jobDescription
            this.jobName = x.jobName
            this.jobType = x.jobType
            this.lastModifiedTime = x.lastModifiedTime
            this.modelName = x.modelName
            this.modelPackageVersionArn = x.modelPackageVersionArn
            this.roleArn = x.roleArn
            this.samplePayloadUrl = x.samplePayloadUrl
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceRecommendationsJob = InferenceRecommendationsJob(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
