// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the properties of an inference component.
 */
public class InferenceComponentSummary private constructor(builder: Builder) {
    /**
     * The time when the inference component was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The name of the endpoint that hosts the inference component.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The Amazon Resource Name (ARN) of the inference component.
     */
    public val inferenceComponentArn: kotlin.String? = builder.inferenceComponentArn
    /**
     * The name of the inference component.
     */
    public val inferenceComponentName: kotlin.String? = builder.inferenceComponentName
    /**
     * The status of the inference component.
     */
    public val inferenceComponentStatus: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStatus? = builder.inferenceComponentStatus
    /**
     * The time when the inference component was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the production variant that hosts the inference component.
     */
    public val variantName: kotlin.String? = builder.variantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentSummary(")
        append("creationTime=$creationTime,")
        append("endpointArn=$endpointArn,")
        append("endpointName=$endpointName,")
        append("inferenceComponentArn=$inferenceComponentArn,")
        append("inferenceComponentName=$inferenceComponentName,")
        append("inferenceComponentStatus=$inferenceComponentStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("variantName=$variantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (inferenceComponentArn?.hashCode() ?: 0)
        result = 31 * result + (inferenceComponentName?.hashCode() ?: 0)
        result = 31 * result + (inferenceComponentStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentSummary

        if (creationTime != other.creationTime) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointName != other.endpointName) return false
        if (inferenceComponentArn != other.inferenceComponentArn) return false
        if (inferenceComponentName != other.inferenceComponentName) return false
        if (inferenceComponentStatus != other.inferenceComponentStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (variantName != other.variantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the inference component was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The name of the endpoint that hosts the inference component.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the inference component.
         */
        public var inferenceComponentArn: kotlin.String? = null
        /**
         * The name of the inference component.
         */
        public var inferenceComponentName: kotlin.String? = null
        /**
         * The status of the inference component.
         */
        public var inferenceComponentStatus: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStatus? = null
        /**
         * The time when the inference component was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the production variant that hosts the inference component.
         */
        public var variantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSummary) : this() {
            this.creationTime = x.creationTime
            this.endpointArn = x.endpointArn
            this.endpointName = x.endpointName
            this.inferenceComponentArn = x.inferenceComponentArn
            this.inferenceComponentName = x.inferenceComponentName
            this.inferenceComponentStatus = x.inferenceComponentStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.variantName = x.variantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSummary = InferenceComponentSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
