// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Settings that take effect while the model container starts up.
 */
public class InferenceComponentStartupParameters private constructor(builder: Builder) {
    /**
     * The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
     */
    public val containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = builder.containerStartupHealthCheckTimeoutInSeconds
    /**
     * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
     */
    public val modelDataDownloadTimeoutInSeconds: kotlin.Int? = builder.modelDataDownloadTimeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentStartupParameters(")
        append("containerStartupHealthCheckTimeoutInSeconds=$containerStartupHealthCheckTimeoutInSeconds,")
        append("modelDataDownloadTimeoutInSeconds=$modelDataDownloadTimeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerStartupHealthCheckTimeoutInSeconds ?: 0
        result = 31 * result + (modelDataDownloadTimeoutInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentStartupParameters

        if (containerStartupHealthCheckTimeoutInSeconds != other.containerStartupHealthCheckTimeoutInSeconds) return false
        if (modelDataDownloadTimeoutInSeconds != other.modelDataDownloadTimeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
         */
        public var containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = null
        /**
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
         */
        public var modelDataDownloadTimeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters) : this() {
            this.containerStartupHealthCheckTimeoutInSeconds = x.containerStartupHealthCheckTimeoutInSeconds
            this.modelDataDownloadTimeoutInSeconds = x.modelDataDownloadTimeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters = InferenceComponentStartupParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
