// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Defines the compute resources to allocate to run a model that you assign to an inference component. These resources include CPU cores, accelerators, and memory.
 */
public class InferenceComponentComputeResourceRequirements private constructor(builder: Builder) {
    /**
     * The maximum MB of memory to allocate to run a model that you assign to an inference component.
     */
    public val maxMemoryRequiredInMb: kotlin.Int? = builder.maxMemoryRequiredInMb
    /**
     * The minimum MB of memory to allocate to run a model that you assign to an inference component.
     */
    public val minMemoryRequiredInMb: kotlin.Int? = builder.minMemoryRequiredInMb
    /**
     * The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and Amazon Web Services Inferentia.
     */
    public val numberOfAcceleratorDevicesRequired: kotlin.Float? = builder.numberOfAcceleratorDevicesRequired
    /**
     * The number of CPU cores to allocate to run a model that you assign to an inference component.
     */
    public val numberOfCpuCoresRequired: kotlin.Float? = builder.numberOfCpuCoresRequired

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentComputeResourceRequirements(")
        append("maxMemoryRequiredInMb=$maxMemoryRequiredInMb,")
        append("minMemoryRequiredInMb=$minMemoryRequiredInMb,")
        append("numberOfAcceleratorDevicesRequired=$numberOfAcceleratorDevicesRequired,")
        append("numberOfCpuCoresRequired=$numberOfCpuCoresRequired")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxMemoryRequiredInMb ?: 0
        result = 31 * result + (minMemoryRequiredInMb ?: 0)
        result = 31 * result + (numberOfAcceleratorDevicesRequired?.hashCode() ?: 0)
        result = 31 * result + (numberOfCpuCoresRequired?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentComputeResourceRequirements

        if (maxMemoryRequiredInMb != other.maxMemoryRequiredInMb) return false
        if (minMemoryRequiredInMb != other.minMemoryRequiredInMb) return false
        if (numberOfAcceleratorDevicesRequired != other.numberOfAcceleratorDevicesRequired) return false
        if (numberOfCpuCoresRequired != other.numberOfCpuCoresRequired) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum MB of memory to allocate to run a model that you assign to an inference component.
         */
        public var maxMemoryRequiredInMb: kotlin.Int? = null
        /**
         * The minimum MB of memory to allocate to run a model that you assign to an inference component.
         */
        public var minMemoryRequiredInMb: kotlin.Int? = null
        /**
         * The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and Amazon Web Services Inferentia.
         */
        public var numberOfAcceleratorDevicesRequired: kotlin.Float? = null
        /**
         * The number of CPU cores to allocate to run a model that you assign to an inference component.
         */
        public var numberOfCpuCoresRequired: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements) : this() {
            this.maxMemoryRequiredInMb = x.maxMemoryRequiredInMb
            this.minMemoryRequiredInMb = x.minMemoryRequiredInMb
            this.numberOfAcceleratorDevicesRequired = x.numberOfAcceleratorDevicesRequired
            this.numberOfCpuCoresRequired = x.numberOfCpuCoresRequired
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements = InferenceComponentComputeResourceRequirements(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
