// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for an endpoint.
 */
public class EndpointSummary private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the endpoint was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The name of the endpoint.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The status of the endpoint.
     * + `OutOfService`: Endpoint is not available to take incoming requests.
     * + `Creating`: [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html) is executing.
     * + `Updating`: [UpdateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html) or [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) is executing.
     * + `SystemUpdating`: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.
     * + `RollingBack`: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an `InService` status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) call or when the [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) operation is called explicitly.
     * + `InService`: Endpoint is available to process incoming requests.
     * + `Deleting`: [DeleteEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html) is executing.
     * + `Failed`: Endpoint could not be created, updated, or re-scaled. Use `DescribeEndpointOutput$FailureReason` for information about the failure. [DeleteEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html) is the only operation that can be performed on a failed endpoint.
     *
     * To get a list of endpoints with a specified status, use the `StatusEquals` filter with a call to [ListEndpoints](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpoints.html).
     */
    public val endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = builder.endpointStatus
    /**
     * A timestamp that shows when the endpoint was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EndpointSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointSummary(")
        append("creationTime=$creationTime,")
        append("endpointArn=$endpointArn,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointSummary

        if (creationTime != other.creationTime) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EndpointSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp that shows when the endpoint was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The name of the endpoint.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The status of the endpoint.
         * + `OutOfService`: Endpoint is not available to take incoming requests.
         * + `Creating`: [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html) is executing.
         * + `Updating`: [UpdateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html) or [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) is executing.
         * + `SystemUpdating`: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.
         * + `RollingBack`: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an `InService` status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) call or when the [UpdateEndpointWeightsAndCapacities](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html) operation is called explicitly.
         * + `InService`: Endpoint is available to process incoming requests.
         * + `Deleting`: [DeleteEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html) is executing.
         * + `Failed`: Endpoint could not be created, updated, or re-scaled. Use `DescribeEndpointOutput$FailureReason` for information about the failure. [DeleteEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html) is the only operation that can be performed on a failed endpoint.
         *
         * To get a list of endpoints with a specified status, use the `StatusEquals` filter with a call to [ListEndpoints](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpoints.html).
         */
        public var endpointStatus: aws.sdk.kotlin.services.sagemaker.model.EndpointStatus? = null
        /**
         * A timestamp that shows when the endpoint was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EndpointSummary) : this() {
            this.creationTime = x.creationTime
            this.endpointArn = x.endpointArn
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EndpointSummary = EndpointSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
