// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeImageVersionResponse private constructor(builder: Builder) {
    /**
     * The registry path of the container image on which this image version is based.
     */
    public val baseImage: kotlin.String? = builder.baseImage
    /**
     * The registry path of the container image that contains this image version.
     */
    public val containerImage: kotlin.String? = builder.containerImage
    /**
     * When the version was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * When a create or delete operation fails, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Indicates Horovod compatibility.
     */
    public val horovod: kotlin.Boolean? = builder.horovod
    /**
     * The ARN of the image the version is based on.
     */
    public val imageArn: kotlin.String? = builder.imageArn
    /**
     * The ARN of the version.
     */
    public val imageVersionArn: kotlin.String? = builder.imageVersionArn
    /**
     * The status of the version.
     */
    public val imageVersionStatus: aws.sdk.kotlin.services.sagemaker.model.ImageVersionStatus? = builder.imageVersionStatus
    /**
     * Indicates SageMaker job type compatibility.
     * + `TRAINING`: The image version is compatible with SageMaker training jobs.
     * + `INFERENCE`: The image version is compatible with SageMaker inference jobs.
     * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker notebook kernels.
     */
    public val jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = builder.jobType
    /**
     * When the version was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The machine learning framework vended in the image version.
     */
    public val mlFramework: kotlin.String? = builder.mlFramework
    /**
     * Indicates CPU or GPU compatibility.
     * + `CPU`: The image version is compatible with CPU.
     * + `GPU`: The image version is compatible with GPU.
     */
    public val processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = builder.processor
    /**
     * The supported programming language and its version.
     */
    public val programmingLang: kotlin.String? = builder.programmingLang
    /**
     * The maintainer description of the image version.
     */
    public val releaseNotes: kotlin.String? = builder.releaseNotes
    /**
     * The stability of the image version specified by the maintainer.
     * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
     * + `STABLE`: The image version is stable.
     * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
     * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
     */
    public val vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = builder.vendorGuidance
    /**
     * The version number.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeImageVersionResponse(")
        append("baseImage=$baseImage,")
        append("containerImage=$containerImage,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("horovod=$horovod,")
        append("imageArn=$imageArn,")
        append("imageVersionArn=$imageVersionArn,")
        append("imageVersionStatus=$imageVersionStatus,")
        append("jobType=$jobType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("mlFramework=$mlFramework,")
        append("processor=$processor,")
        append("programmingLang=$programmingLang,")
        append("releaseNotes=$releaseNotes,")
        append("vendorGuidance=$vendorGuidance,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseImage?.hashCode() ?: 0
        result = 31 * result + (containerImage?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (horovod?.hashCode() ?: 0)
        result = 31 * result + (imageArn?.hashCode() ?: 0)
        result = 31 * result + (imageVersionArn?.hashCode() ?: 0)
        result = 31 * result + (imageVersionStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (mlFramework?.hashCode() ?: 0)
        result = 31 * result + (processor?.hashCode() ?: 0)
        result = 31 * result + (programmingLang?.hashCode() ?: 0)
        result = 31 * result + (releaseNotes?.hashCode() ?: 0)
        result = 31 * result + (vendorGuidance?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeImageVersionResponse

        if (baseImage != other.baseImage) return false
        if (containerImage != other.containerImage) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (horovod != other.horovod) return false
        if (imageArn != other.imageArn) return false
        if (imageVersionArn != other.imageVersionArn) return false
        if (imageVersionStatus != other.imageVersionStatus) return false
        if (jobType != other.jobType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (mlFramework != other.mlFramework) return false
        if (processor != other.processor) return false
        if (programmingLang != other.programmingLang) return false
        if (releaseNotes != other.releaseNotes) return false
        if (vendorGuidance != other.vendorGuidance) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The registry path of the container image on which this image version is based.
         */
        public var baseImage: kotlin.String? = null
        /**
         * The registry path of the container image that contains this image version.
         */
        public var containerImage: kotlin.String? = null
        /**
         * When the version was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When a create or delete operation fails, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Indicates Horovod compatibility.
         */
        public var horovod: kotlin.Boolean? = null
        /**
         * The ARN of the image the version is based on.
         */
        public var imageArn: kotlin.String? = null
        /**
         * The ARN of the version.
         */
        public var imageVersionArn: kotlin.String? = null
        /**
         * The status of the version.
         */
        public var imageVersionStatus: aws.sdk.kotlin.services.sagemaker.model.ImageVersionStatus? = null
        /**
         * Indicates SageMaker job type compatibility.
         * + `TRAINING`: The image version is compatible with SageMaker training jobs.
         * + `INFERENCE`: The image version is compatible with SageMaker inference jobs.
         * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker notebook kernels.
         */
        public var jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = null
        /**
         * When the version was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The machine learning framework vended in the image version.
         */
        public var mlFramework: kotlin.String? = null
        /**
         * Indicates CPU or GPU compatibility.
         * + `CPU`: The image version is compatible with CPU.
         * + `GPU`: The image version is compatible with GPU.
         */
        public var processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = null
        /**
         * The supported programming language and its version.
         */
        public var programmingLang: kotlin.String? = null
        /**
         * The maintainer description of the image version.
         */
        public var releaseNotes: kotlin.String? = null
        /**
         * The stability of the image version specified by the maintainer.
         * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
         * + `STABLE`: The image version is stable.
         * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
         * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
         */
        public var vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = null
        /**
         * The version number.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse) : this() {
            this.baseImage = x.baseImage
            this.containerImage = x.containerImage
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.horovod = x.horovod
            this.imageArn = x.imageArn
            this.imageVersionArn = x.imageVersionArn
            this.imageVersionStatus = x.imageVersionStatus
            this.jobType = x.jobType
            this.lastModifiedTime = x.lastModifiedTime
            this.mlFramework = x.mlFramework
            this.processor = x.processor
            this.programmingLang = x.programmingLang
            this.releaseNotes = x.releaseNotes
            this.vendorGuidance = x.vendorGuidance
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse = DescribeImageVersionResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
