// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



public class CreateWorkforceRequest private constructor(builder: Builder) {
    /**
     * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
     *
     * Do not use `OidcConfig` if you specify values for `CognitoConfig`.
     */
    public val cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = builder.cognitoConfig
    /**
     * Use this parameter to configure a private workforce using your own OIDC Identity Provider.
     *
     * Do not use `CognitoConfig` if you specify values for `OidcConfig`.
     */
    public val oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfig? = builder.oidcConfig
    /**
     * A list of IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.
     */
    public val sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = builder.sourceIpConfig
    /**
     * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the private workforce.
     */
    public val workforceName: kotlin.String? = builder.workforceName
    /**
     * Use this parameter to configure a workforce using VPC.
     */
    public val workforceVpcConfig: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest? = builder.workforceVpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateWorkforceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkforceRequest(")
        append("cognitoConfig=$cognitoConfig,")
        append("oidcConfig=$oidcConfig,")
        append("sourceIpConfig=$sourceIpConfig,")
        append("tags=$tags,")
        append("workforceName=$workforceName,")
        append("workforceVpcConfig=$workforceVpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cognitoConfig?.hashCode() ?: 0
        result = 31 * result + (oidcConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceIpConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workforceName?.hashCode() ?: 0)
        result = 31 * result + (workforceVpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkforceRequest

        if (cognitoConfig != other.cognitoConfig) return false
        if (oidcConfig != other.oidcConfig) return false
        if (sourceIpConfig != other.sourceIpConfig) return false
        if (tags != other.tags) return false
        if (workforceName != other.workforceName) return false
        if (workforceVpcConfig != other.workforceVpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateWorkforceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single [ Amazon Cognito user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
         *
         * Do not use `OidcConfig` if you specify values for `CognitoConfig`.
         */
        public var cognitoConfig: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig? = null
        /**
         * Use this parameter to configure a private workforce using your own OIDC Identity Provider.
         *
         * Do not use `CognitoConfig` if you specify values for `OidcConfig`.
         */
        public var oidcConfig: aws.sdk.kotlin.services.sagemaker.model.OidcConfig? = null
        /**
         * A list of IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.
         */
        public var sourceIpConfig: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig? = null
        /**
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the private workforce.
         */
        public var workforceName: kotlin.String? = null
        /**
         * Use this parameter to configure a workforce using VPC.
         */
        public var workforceVpcConfig: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateWorkforceRequest) : this() {
            this.cognitoConfig = x.cognitoConfig
            this.oidcConfig = x.oidcConfig
            this.sourceIpConfig = x.sourceIpConfig
            this.tags = x.tags
            this.workforceName = x.workforceName
            this.workforceVpcConfig = x.workforceVpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateWorkforceRequest = CreateWorkforceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CognitoConfig] inside the given [block]
         */
        public fun cognitoConfig(block: aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.Builder.() -> kotlin.Unit) {
            this.cognitoConfig = aws.sdk.kotlin.services.sagemaker.model.CognitoConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OidcConfig] inside the given [block]
         */
        public fun oidcConfig(block: aws.sdk.kotlin.services.sagemaker.model.OidcConfig.Builder.() -> kotlin.Unit) {
            this.oidcConfig = aws.sdk.kotlin.services.sagemaker.model.OidcConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig] inside the given [block]
         */
        public fun sourceIpConfig(block: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.Builder.() -> kotlin.Unit) {
            this.sourceIpConfig = aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest] inside the given [block]
         */
        public fun workforceVpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest.Builder.() -> kotlin.Unit) {
            this.workforceVpcConfig = aws.sdk.kotlin.services.sagemaker.model.WorkforceVpcConfigRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
